/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodCollector;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodPattern;
import java.lang.reflect.Method;

public class CreateBeanInstanceInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();
    private volatile Method getInstanceMethod;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (!AgentConfigManager.isTransformSpringBean()) {
            return;
        }
        try {
            if (result == null) {
                return;
            }
            Method getWrappedInstanceMethod = this.getInstanceMethod(result);
            if (getWrappedInstanceMethod != null) {
                Class<?> beanClass = getWrappedInstanceMethod.invoke(result, new Object[0]).getClass();
                if (beanClass == null) {
                    return;
                }
                SpringBeanMethodPattern methodPattern = new SpringBeanMethodPattern();
                String beanName = beanClass.getName();
                methodPattern.setClassName(beanName);
                if (beanName.startsWith("org.springframework")) {
                    return;
                }
                SpringBeanMethodCollector.getInstance().retransForm(methodPattern, beanClass);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "CreateBeanInstanceInterceptor onFinally error", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getInstanceMethod(Object obj) throws NoSuchMethodException {
        if (this.getInstanceMethod != null) {
            return this.getInstanceMethod;
        }
        CreateBeanInstanceInterceptor createBeanInstanceInterceptor = this;
        synchronized (createBeanInstanceInterceptor) {
            if (this.getInstanceMethod != null) {
                return this.getInstanceMethod;
            }
            Class<?> aClass = obj.getClass();
            Method getMethod = aClass.getMethod("getWrappedInstance", new Class[0]);
            if (getMethod != null) {
                this.getInstanceMethod = getMethod;
                return this.getInstanceMethod;
            }
        }
        return null;
    }
}

