/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.listener;

import com.lubanops.apm.bootstrap.NoneNamedListener;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodCollector;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodPattern;
import com.lubanops.apm.plugin.spring.interceptor.SpringBeansInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SpringBeansListener
implements NoneNamedListener {
    private static final Logger LOGGER = LogFactory.getLogger();

    public void init() {
        CollectorManager.TAGS.add("SpringBean");
    }

    public List<String> matchClass(String className, byte[] classfileBuffer) {
        if (className == null) {
            return null;
        }
        if (className.startsWith("sun/") || className.startsWith("java/") || className.startsWith("javax/") || className.startsWith("org/springframework/")) {
            return null;
        }
        if (className.startsWith("com/lubanops/apm/bootstrap") || className.startsWith("com/lubanops/apm/premain") || className.startsWith("com/lubanops/apm/transformer")) {
            return null;
        }
        if (className.contains("$")) {
            return null;
        }
        HashMap methodPatternMap = SpringBeanMethodCollector.getInstance().getMethodPatternMap();
        if (methodPatternMap == null || methodPatternMap.isEmpty()) {
            return null;
        }
        if (methodPatternMap.keySet().contains(className)) {
            CollectorManager.SPRING_BEAN_COUNT.incrementAndGet();
            LOGGER.info(className + "transform is: " + CollectorManager.SPRING_BEAN_COUNT);
            SpringBeanMethodCollector.setNeedCount((String)className, (Boolean)((SpringBeanMethodPattern)methodPatternMap.get(className)).isStatistics());
            return new ArrayList<String>();
        }
        return null;
    }

    public String getInterceptor() {
        return SpringBeansInterceptor.class.getName();
    }

    public boolean hasAttribute() {
        return false;
    }

    public boolean appendBootstrapClassLoader() {
        return false;
    }
}

