/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.plugin.mongodb.ClusterObjectHolder;
import com.lubanops.apm.plugin.mongodb.ConnectionCloseReason;
import com.lubanops.apm.plugin.mongodb.collector.MongoClientAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoClusterAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoClusterInfoAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoConnectionAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoConnectionPoolAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoNodeAggregator;
import com.lubanops.apm.plugin.mongodb.collector.MongoVersionAggregator;
import com.mongodb.connection.ServerType;
import java.util.Map;

public class MongoDbCollector
extends Collector {
    public static final MongoDbCollector INSTANCE = new MongoDbCollector();
    public static final MongoClientAggregator MONGO_CLIENT_AGGREGATOR = new MongoClientAggregator();
    public static final MongoClusterInfoAggregator MONGO_CLUSTER_INFO_AGGREGATOR = new MongoClusterInfoAggregator();
    public static final MongoClusterAggregator MONGO_CLUSTER_AGGREGATOR = new MongoClusterAggregator();
    public static final MongoNodeAggregator MONGO_NODE_AGGREGATOR = new MongoNodeAggregator();
    public static final MongoConnectionAggregator MONGO_CONNECTION_AGGREGATOR = new MongoConnectionAggregator();
    public static final MongoConnectionPoolAggregator MONGO_CONNECTION_POOL_AGGREGATOR = new MongoConnectionPoolAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final MongoVersionAggregator MONGO_VERSION_AGGREGATOR = new MongoVersionAggregator();
    private static int maximumCommandLength = 2000;

    public static void incrementQueryCount(long count) {
        if (count > 0L) {
            MONGO_CLIENT_AGGREGATOR.incrementQueryCount(count);
        }
    }

    public static void incrementUpdateCount(long count) {
        if (count > 0L) {
            MONGO_CLIENT_AGGREGATOR.incrementUpdateCount(count);
        }
    }

    public static void onStart(String namespace, String command, String node) {
        String nodes = ClusterObjectHolder.getMongoClusterHostsByHost(node);
        if (nodes == null) {
            nodes = "unknown";
        }
        MONGO_CLIENT_AGGREGATOR.onStart(namespace, command);
        MONGO_CLUSTER_AGGREGATOR.onStart(nodes);
    }

    public static void onError(String errorTraceId) {
        MONGO_CLIENT_AGGREGATOR.onError(errorTraceId);
        MONGO_CLUSTER_AGGREGATOR.onError(errorTraceId);
    }

    public static void onFinally() {
        MONGO_CLIENT_AGGREGATOR.onFinally();
        MONGO_CLUSTER_AGGREGATOR.onFinally();
    }

    public static void nodeOnStart(String serverAddress, ServerType serverType) {
        MONGO_NODE_AGGREGATOR.onStart(serverAddress, serverType);
    }

    public static void nodeOnError(String errorTraceId) {
        MONGO_NODE_AGGREGATOR.onError(errorTraceId);
    }

    public static void nodeOnFinally() {
        MONGO_NODE_AGGREGATOR.onFinally();
    }

    public static void connectionOnStart(String host) {
        MONGO_CONNECTION_AGGREGATOR.onStart(host);
    }

    public static void connectionOnThrowable(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
        MONGO_CONNECTION_AGGREGATOR.onError();
    }

    public static void connectionOpen(String host) {
        MONGO_CONNECTION_AGGREGATOR.onConnectionOpen(host);
    }

    public static void connectionClose(String host, ConnectionCloseReason reason) {
        MONGO_CONNECTION_AGGREGATOR.onConnectionClose(host, reason);
    }

    public static void connectionOnFinally() {
        MONGO_CONNECTION_AGGREGATOR.onFinally();
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static int getMaximumCommandLength() {
        return maximumCommandLength;
    }

    public static void setMaximumCommandLength(int maximumCommandLength) {
        MongoDbCollector.maximumCommandLength = maximumCommandLength;
    }

    public static String getDriverVersion(String version) {
        return MONGO_VERSION_AGGREGATOR.getVersion();
    }

    public static boolean is3xxVersion() {
        return MONGO_VERSION_AGGREGATOR.is3xxVersion();
    }

    public static boolean is4xxVersion() {
        return MONGO_VERSION_AGGREGATOR.is4xxVersion();
    }

    public static void setDriverVersion(String version) {
        MONGO_VERSION_AGGREGATOR.setVersion(version);
    }

    public static int getTimeSpanThreshold() {
        return MONGO_CONNECTION_AGGREGATOR.getTimeSpanThreshold();
    }

    public void parseParameter(Map<String, String> parameters) {
        MONGO_CONNECTION_AGGREGATOR.parseParameters(parameters);
        MONGO_CLIENT_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "MongoDb";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_CLIENT_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_CLUSTER_INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_NODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_CONNECTION_POOL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)MONGO_VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

