/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.MongoContext;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;

public class OperationExecutionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                Object operation = args[0];
                if (operation.getClass().getSimpleName().contains("AggregateOperation") && operation instanceof AttributeAccess) {
                    operation = ((AttributeAccess)operation).getLopsFileds()[0];
                }
                MongoContext.OPERATION_LOCAL.set(operation);
            }
        }
        catch (Exception executionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
            }
        }
        catch (Exception executionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                MongoContext.OPERATION_LOCAL.set(null);
            }
        }
        catch (Exception executionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executionException);
        }
    }
}

