/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.lettuce.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandType;

public class CreateCommandInterceptor
implements Interceptor {
    public static final int BLOB_THRESHOLD = 1000;
    public static final String SERVICE_TYPE = "REDIS_CLIENT";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        CommandType commandType = (CommandType)args[0];
        Command command = (Command)result;
        String method = commandType.name();
        if (RedisCollector.getInstance().isEnable() && RedisTransformHelper.needParseBody(method)) {
            SpanEvent apmSpanEvent = TraceCollector.onStart((String)className, (String)method, (String)SERVICE_TYPE, (String)method, (String)"CLIENT");
            TransformAccess transformAccess = (TransformAccess)command;
            FutureStatsAccessor futureStatsAccessor = new FutureStatsAccessor();
            transformAccess.setLopsAttribute((Object)futureStatsAccessor);
            futureStatsAccessor.setStartTime(System.nanoTime());
            futureStatsAccessor.setSpanEvent(apmSpanEvent);
            TraceCollector.onFinally((boolean)false);
        }
    }
}

