/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

class Arguments {
    String title = "Flame Graph";
    String highlight;
    String state;
    Pattern include;
    Pattern exclude;
    double minwidth;
    int skip;
    boolean reverse;
    boolean alloc;
    boolean live;
    boolean lock;
    boolean threads;
    boolean classify;
    boolean total;
    boolean lines;
    boolean bci;
    boolean simple;
    boolean dot;
    boolean collapsed;
    long from;
    long to;
    String input;
    String output;

    Arguments(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("--")) {
                try {
                    Field field = Arguments.class.getDeclaredField(string.substring(2));
                    if ((field.getModifiers() & 0x1A) != 0) {
                        throw new IllegalStateException(string);
                    }
                    Class<?> clazz = field.getType();
                    if (clazz == String.class) {
                        field.set(this, stringArray[++i]);
                        continue;
                    }
                    if (clazz == Boolean.TYPE) {
                        field.setBoolean(this, true);
                        continue;
                    }
                    if (clazz == Integer.TYPE) {
                        field.setInt(this, Integer.parseInt(stringArray[++i]));
                        continue;
                    }
                    if (clazz == Double.TYPE) {
                        field.setDouble(this, Double.parseDouble(stringArray[++i]));
                        continue;
                    }
                    if (clazz == Long.TYPE) {
                        field.setLong(this, this.parseTimestamp(stringArray[++i]));
                        continue;
                    }
                    if (clazz != Pattern.class) continue;
                    field.set(this, Pattern.compile(stringArray[++i]));
                    continue;
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (string.isEmpty()) continue;
            if (this.input == null) {
                this.input = string;
                continue;
            }
            this.output = string;
        }
    }

    private long parseTimestamp(String string) {
        if (string.indexOf(58) < 0) {
            return Long.parseLong(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-:.T");
        if (string.indexOf(84) > 0) {
            gregorianCalendar.set(1, Integer.parseInt(stringTokenizer.nextToken()));
            gregorianCalendar.set(2, Integer.parseInt(stringTokenizer.nextToken()) - 1);
            gregorianCalendar.set(5, Integer.parseInt(stringTokenizer.nextToken()));
        }
        gregorianCalendar.set(11, stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0);
        gregorianCalendar.set(12, stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0);
        gregorianCalendar.set(13, stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0);
        gregorianCalendar.set(14, stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0);
        return gregorianCalendar.getTimeInMillis();
    }
}

