/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse.collector;

import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcConnectionAggregator;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.util.List;
import java.util.Map;

public class ClickHouseConnectionAggregator
extends JdbcConnectionAggregator {
    protected static final String TAG_CLUSTER_URLS = "cnclusterurls";

    public ConnectionStats onConnectionStart(Integer connectionId, String clusterUrls) {
        ConnectionStats res = super.onConnectionStart(connectionId);
        Map map = this.getContextMap();
        if (clusterUrls != null) {
            map.put(TAG_CLUSTER_URLS, clusterUrls);
        }
        return res;
    }

    public void onFinally(String sql, int updatedCount, int readRowCount, String collectorName) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        Long t = (Long)this.getContextValue(map, "cnstart");
        if (t == null) {
            return;
        }
        ConnectionStats stat = (ConnectionStats)this.getContextValue(map, "cnstats");
        Boolean hasError = (Boolean)this.getContextValue(map, "error");
        Integer connectionId = (Integer)this.getContextValue(map, "cnid");
        String connectionString = (String)this.getContextValue(map, TAG_CLUSTER_URLS);
        if (connectionId != null && connectionString == null) {
            connectionString = Helper.CONNECTION_TARGET_MAP.getResource(connectionId.intValue());
        }
        if (hasError == null) {
            hasError = false;
        }
        long timeUsed = System.nanoTime() - t;
        if (stat != null) {
            stat.onFinally(timeUsed, sql, updatedCount, readRowCount);
        }
        TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)connectionString, (List)TransactionCollector.getTxName(), (String)collectorName);
        this.clearThreadLocal();
    }
}

