/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler.commons.protocol.bindings;

import com.google.protobuf.Message;
import com.huawei.cloud.profiler.commons.protocol.bindings.MultiplexingDataProvider;
import com.huawei.cloud.profiler.commons.protocol.bindings.ProtobufMultiplexingConverter;
import com.huawei.cloud.profiler.commons.protocol.bindings.json.MultiplexingGroupName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class ProtobufMultiplexingByBytePrefixConverter
implements ProtobufMultiplexingConverter {
    private static final int PROFILER_ADDITIONAL_HEADER_SIZE = 1;
    private final MultiplexingDataProvider dataProvider;

    @Override
    public byte[] serialize(MultiplexingGroupName multiplexingGroupName, Message source) {
        byte[] byArray;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(1 + source.getSerializedSize());){
            byte code = this.dataProvider.getMultiplexingCode(multiplexingGroupName, source.getClass());
            bos.write(code);
            source.writeTo((OutputStream)bos);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    @Override
    public byte[] serialize(Message source) {
        byte[] byArray;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(source.getSerializedSize());){
            source.writeTo((OutputStream)bos);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    @Override
    public Message deserialize(MultiplexingGroupName multiplexingGroupName, byte[] binaryData) {
        Message message;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(binaryData);){
            byte[] code = new byte[1];
            bis.read(code, 0, 1);
            Class<? extends Message> msgClass = this.dataProvider.getMultiplexingMsgClass(multiplexingGroupName, code[0]);
            Method m = msgClass.getMethod("parseFrom", InputStream.class);
            message = (Message)m.invoke(null, bis);
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends Message> T deserialize(byte[] binaryData, Class<T> type) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(binaryData);){
            Method m = type.getMethod("parseFrom", InputStream.class);
            Message message = (Message)m.invoke(null, bis);
            return (T)message;
        }
    }

    public ProtobufMultiplexingByBytePrefixConverter(MultiplexingDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }
}

