/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsContext;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClientStats;
import java.util.HashMap;
import org.elasticsearch.client.RestClient;

public class PerformRequestOldInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                if (EsRestClientCollector.isRestClientHighThanOrEqualTo64()) {
                    return new Object[0];
                }
                if (EsRestClientCollector.isRestClientHighThanOrEqualTo63()) {
                    RestClient client = (RestClient)object;
                    Integer num = ClientObjectHolder.getOrRegister(client);
                    String clientNum = String.valueOf(num);
                    String method = (String)args[0];
                    String endpoint = (String)args[1];
                    EsClientStats stats = EsRestClientCollector.onStart(clientNum, EsUtils.convertEndpoint(endpoint), method);
                    SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"EsRestClient");
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("spanEvent", spanEvent);
                    context.put("stats", (Object)stats);
                    EsContext.TRACE_MAP_LOCAL.set(context);
                } else {
                    TraceCollector.onStart((String)className, (String)(methodName + "Old"), (String)"EsRestClient");
                }
            }
        }
        catch (Exception performRequestException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performRequestException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable() && !EsRestClientCollector.isRestClientHighThanOrEqualTo64() && EsRestClientCollector.isRestClientHighThanOrEqualTo63()) {
                EsRestClientCollector.onResponseClose();
                TraceCollector.onFinally();
                EsContext.TRACE_MAP_LOCAL.set(null);
            }
        }
        catch (Exception performRequestInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performRequestInterceptor);
        }
    }
}

