/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.collection;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.util.collection.GaStack;
import java.util.NoSuchElementException;

public class ThreadUnsafeGaStack<E>
implements GaStack<E> {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUnsafeGaStack.class);
    private static final int EMPTY_INDEX = -1;
    private static final int DEFAULT_STACK_DEEP = 12;
    private Object[] elementArray;
    private int current = -1;

    public ThreadUnsafeGaStack() {
        this(12);
    }

    private ThreadUnsafeGaStack(int stackSize) {
        this.elementArray = new Object[stackSize];
    }

    private void ensureCapacityInternal(int expectDeep) {
        int currentStackSize = this.elementArray.length;
        if (this.elementArray.length <= expectDeep) {
            if (logger.isDebugEnabled()) {
                logger.debug("resize GaStack to double length: " + currentStackSize * 2 + " for thread: " + Thread.currentThread().getName());
            }
            Object[] newElementArray = new Object[currentStackSize * 2];
            System.arraycopy(this.elementArray, 0, newElementArray, 0, currentStackSize);
            this.elementArray = newElementArray;
        }
    }

    private void checkForPopOrPeek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E pop() {
        try {
            this.checkForPopOrPeek();
            Object res = this.elementArray[this.current];
            this.elementArray[this.current] = null;
            --this.current;
            Object object = res;
            return (E)object;
        }
        finally {
            if (this.current == -1 && this.elementArray.length > 12) {
                this.elementArray = new Object[12];
                if (logger.isDebugEnabled()) {
                    logger.debug("resize GaStack to default length for thread: " + Thread.currentThread().getName());
                }
            }
        }
    }

    @Override
    public void push(E e) {
        this.ensureCapacityInternal(this.current + 1);
        this.elementArray[++this.current] = e;
    }

    @Override
    public E peek() {
        this.checkForPopOrPeek();
        return (E)this.elementArray[this.current];
    }

    @Override
    public boolean isEmpty() {
        return this.current == -1;
    }
}

