/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq;

import com.rabbitmq.client.impl.AMQConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RabbitConnectionHolder {
    public static final ConcurrentHashMap<String, Set<AMQConnection>> CONNECTION_HOLDER = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnection(AMQConnection connection) {
        Set<AMQConnection> set;
        if (connection == null) {
            return;
        }
        String connectionAsString = connection.toString();
        if (!CONNECTION_HOLDER.containsKey(connectionAsString) && CONNECTION_HOLDER.size() < 20) {
            ConcurrentHashMap<String, Set<AMQConnection>> concurrentHashMap = CONNECTION_HOLDER;
            synchronized (concurrentHashMap) {
                if (!CONNECTION_HOLDER.containsKey(connectionAsString)) {
                    CONNECTION_HOLDER.put(connectionAsString, Collections.synchronizedSet(new HashSet()));
                }
            }
        }
        if ((set = CONNECTION_HOLDER.get(connectionAsString)) != null && set.size() < 100) {
            set.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConnection(AMQConnection connection) {
        Set<AMQConnection> set;
        if (connection == null) {
            return;
        }
        String connectionAsString = connection.toString();
        if (CONNECTION_HOLDER.containsKey(connectionAsString) && (set = CONNECTION_HOLDER.get(connectionAsString)) != null) {
            set.remove(connection);
            if (set.size() == 0) {
                ConcurrentHashMap<String, Set<AMQConnection>> concurrentHashMap = CONNECTION_HOLDER;
                synchronized (concurrentHashMap) {
                    set = CONNECTION_HOLDER.get(connectionAsString);
                    if (set != null && set.size() == 0) {
                        CONNECTION_HOLDER.remove(connectionAsString);
                    }
                }
            }
        }
    }
}

