/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitChannelHolder;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionHolder;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class RabbitMqUtils {
    public static String generateConsumerId(String consumerTag, Consumer consumer) {
        return consumerTag + "/" + consumer.getClass().getName();
    }

    public static int getUnackedMsgCountByConnUrl(String connectionUrl) {
        int unackedMsgCount = 0;
        Set<AMQConnection> connectionSet = RabbitConnectionHolder.CONNECTION_HOLDER.get(connectionUrl);
        if (connectionSet != null) {
            for (AMQConnection connection : connectionSet) {
                ChannelManager channelManager = (ChannelManager)((AttributeAccess)connection).getLopsFileds()[0];
                Map channelNMap = (Map)((AttributeAccess)channelManager).getLopsFileds()[0];
                for (ChannelN channelN : channelNMap.values()) {
                    unackedMsgCount = (int)((long)unackedMsgCount + RabbitMqUtils.getUnackedMsgCountByChannel(channelN));
                }
            }
        }
        return unackedMsgCount;
    }

    public static int getUnackedMsgCountByConsumerId(String consumerIdentifier) {
        int unackedMsgCount = 0;
        Set<ChannelN> channelSet = RabbitChannelHolder.CHANNEL_HOLDER.get(consumerIdentifier);
        if (channelSet != null) {
            for (ChannelN channel : channelSet) {
                unackedMsgCount = (int)((long)unackedMsgCount + RabbitMqUtils.getUnackedMsgCountByChannel(channel));
            }
        }
        return unackedMsgCount;
    }

    public static long getUnackedMsgCountByChannel(ChannelN channel) {
        int res = 0;
        Set unackedMsgs = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)channel, (String)"unackedMessageDeliveryTags");
        if (unackedMsgs != null) {
            res = unackedMsgs.size();
        }
        return res;
    }

    public static AMQP.BasicProperties propertiesWithLubanAttr(AMQP.BasicProperties properties, String traceId) {
        if (properties != null) {
            Map headers = properties.getHeaders();
            HashMap<String, String> newHeaders = headers != null ? new HashMap(headers) : new HashMap<String, String>();
            newHeaders.put("lubanOpsTraceId", traceId);
            properties = new AMQP.BasicProperties(properties.getContentType(), properties.getContentEncoding(), newHeaders, properties.getDeliveryMode(), properties.getPriority(), properties.getCorrelationId(), properties.getReplyTo(), properties.getExpiration(), properties.getMessageId(), properties.getTimestamp(), properties.getType(), properties.getUserId(), properties.getAppId(), properties.getClusterId());
        } else {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("lubanOpsTraceId", traceId);
            properties = new AMQP.BasicProperties.Builder().headers(headers).build();
        }
        return properties;
    }

    public static void addLubanOpsAttr(SpanEvent spanEvent, AMQP.BasicProperties properties) {
        Object traceIdOfProducer;
        Map headers;
        if (spanEvent != null && properties != null && (headers = properties.getHeaders()) != null && (traceIdOfProducer = headers.get("lubanOpsTraceId")) != null) {
            spanEvent.addTag("produce-traceid", traceIdOfProducer.toString());
        }
    }

    public static void accumulateCount(MonitorDataRow oldRow, String key, MonitorDataRow ... newRows) {
        Long oldCount = (Long)oldRow.get((Object)key);
        if (oldCount == null) {
            oldCount = 0L;
        }
        for (MonitorDataRow newRow : newRows) {
            Long newCount = (Long)newRow.get((Object)key);
            if (newCount == null) {
                newCount = 0L;
            }
            newRow.put((Object)key, (Object)(newCount + oldCount));
        }
    }

    public static boolean setMax(MonitorDataRow oldRow, String key, MonitorDataRow newRow) {
        Long newCount;
        Long oldCount = (Long)oldRow.get((Object)key);
        if (oldCount == null) {
            oldCount = 0L;
        }
        if ((newCount = (Long)newRow.get((Object)key)) == null) {
            newCount = 0L;
        }
        newRow.put((Object)key, (Object)Math.max(oldCount, newCount));
        return oldCount >= newCount;
    }

    public static void setMax(MonitorDataRow oldRow, String key, MonitorDataRow ... newRows) {
        Long oldCount = (Long)oldRow.get((Object)key);
        if (oldCount == null) {
            oldCount = 0L;
        }
        for (MonitorDataRow newRow : newRows) {
            Long newCount = (Long)newRow.get((Object)key);
            if (newCount == null) {
                newCount = 0L;
            }
            newRow.put((Object)key, (Object)Math.max(oldCount, newCount));
        }
    }

    public static void setStringValIfNull(MonitorDataRow oldRow, String key, MonitorDataRow ... newRows) {
        String strVal = (String)oldRow.get((Object)key);
        if (strVal != null) {
            for (MonitorDataRow newRow : newRows) {
                newRow.put((Object)key, (Object)strVal);
            }
        }
    }

    public void accumulateCount(MonitorDataRow row, String[] keys, MonitorDataRow[] rows) {
        for (String key : keys) {
            RabbitMqUtils.accumulateCount(row, key, rows);
        }
    }

    public void setMax(MonitorDataRow row, String[] keys, MonitorDataRow[] rows) {
        for (String key : keys) {
            RabbitMqUtils.setMax(row, key, rows);
        }
    }

    public static void setStringValIfNull(MonitorDataRow oldRow, String[] keys, MonitorDataRow[] newRows) {
        for (String key : keys) {
            String strVal = (String)oldRow.get((Object)key);
            if (strVal == null) continue;
            for (MonitorDataRow newRow : newRows) {
                if (newRow.containsKey((Object)key)) continue;
                newRow.put((Object)key, (Object)strVal);
            }
        }
    }
}

