/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.bpreload;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import com.lubanops.apm.plugin.rabbitmq.apreload.RabbitMqInvokeStats;
import java.util.concurrent.atomic.AtomicLong;

public class RabbitMqConsumeInvokeStats
extends RabbitMqInvokeStats {
    private volatile long consumedMsgCountOld;
    private volatile long consumedBytesOld;
    private volatile long manualAckCountOld;
    private volatile long rejectCountOld;
    private volatile long requeueCountOld;
    private final AtomicLong consumedMsgCount = new AtomicLong();
    private final AtomicLong consumedBytes = new AtomicLong();
    private final AtomicLong maxSingleMsgBytes = new AtomicLong();
    private final AtomicLong manualAckCount = new AtomicLong();
    private final AtomicLong rejectCount = new AtomicLong();
    private final AtomicLong requeueCount = new AtomicLong();

    public void incrementConsumedMsgCount() {
        this.consumedMsgCount.incrementAndGet();
    }

    public void incrementConsumedBytesCount(int count) {
        this.consumedBytes.addAndGet(count);
    }

    public void setMaxSingleMsgBytes(int msgBytes) {
        ConcurrentUtil.setMaxValue((AtomicLong)this.maxSingleMsgBytes, (long)msgBytes);
    }

    public void incrementManualAckCount(int count) {
        this.manualAckCount.addAndGet(count);
    }

    public void incrementRejectCount(int count) {
        this.rejectCount.addAndGet(count);
    }

    public void incrementRequeueCount(int count) {
        this.requeueCount.addAndGet(count);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"consumedMsgCount", (Object)this.consumedMsgCount.get());
        row.put((Object)"consumedBytes", (Object)this.consumedBytes.get());
        row.put((Object)"maxSingleMsgBytes", (Object)this.maxSingleMsgBytes.get());
        row.put((Object)"manualAckCount", (Object)this.manualAckCount.get());
        row.put((Object)"rejectCount", (Object)this.rejectCount.get());
        row.put((Object)"requeueCount", (Object)this.requeueCount.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        long consumedMsgCountNew = this.consumedMsgCount.get();
        long consumedBytesNew = this.consumedBytes.get();
        long manualAckCountNew = this.manualAckCount.get();
        long rejectCountNew = this.rejectCount.get();
        long requeueCountNew = this.requeueCount.get();
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            row.put((Object)"consumedMsgCount", (Object)(consumedMsgCountNew - this.consumedMsgCountOld));
            row.put((Object)"consumedBytes", (Object)(consumedBytesNew - this.consumedBytesOld));
            row.put((Object)"maxSingleMsgBytes", (Object)this.maxSingleMsgBytes.get());
            row.put((Object)"manualAckCount", (Object)(manualAckCountNew - this.manualAckCountOld));
            row.put((Object)"rejectCount", (Object)(rejectCountNew - this.rejectCountOld));
            row.put((Object)"requeueCount", (Object)(requeueCountNew - this.requeueCountOld));
        }
        this.consumedMsgCountOld = consumedMsgCountNew;
        this.consumedBytesOld = consumedBytesNew;
        this.manualAckCountOld = manualAckCountNew;
        this.rejectCountOld = rejectCountNew;
        this.requeueCountOld = requeueCountNew;
        return row;
    }
}

