/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.common.stats.RabbitMqConnectionCountStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RabbitMqConnectionCountAggregator
extends SinglePrimaryKeyAggregator<RabbitMqConnectionCountStats> {
    public void incrementConnectionCreatedCount(String connectionAddr, int count) {
        RabbitMqConnectionCountStats stats = (RabbitMqConnectionCountStats)this.getValue(connectionAddr);
        if (stats.getConnection() == null) {
            stats.setConnection(connectionAddr);
        }
        stats.incrementConnectionCreatedCount(count);
    }

    public void incrementConnectionClosedCount(String connectionAddr, int count) {
        RabbitMqConnectionCountStats stats = (RabbitMqConnectionCountStats)this.getValue(connectionAddr);
        if (stats.getConnection() == null) {
            stats.setConnection(connectionAddr);
        }
        stats.incrementConnectionClosedCount(count);
    }

    public void incrementChannelCreatedCount(String connectionAddr, int count) {
        RabbitMqConnectionCountStats stats = (RabbitMqConnectionCountStats)this.getValue(connectionAddr);
        if (stats.getConnection() == null) {
            stats.setConnection(connectionAddr);
        }
        stats.incrementChannelCreatedCount(count);
    }

    public void incrementChannelClosedCount(String connectionAddr, int count) {
        RabbitMqConnectionCountStats stats = (RabbitMqConnectionCountStats)this.getValue(connectionAddr);
        if (stats.getConnection() == null) {
            stats.setConnection(connectionAddr);
        }
        stats.incrementChannelClosedCount(count);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected != null && !collected.isEmpty()) {
            HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
            ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
            MonitorDataRow totalRow = new MonitorDataRow();
            for (MonitorDataRow row : collected) {
                RabbitMqUtils.accumulateCount(row, "connectionCount", totalRow);
                RabbitMqUtils.accumulateCount(row, "channelCount", totalRow);
                RabbitMqUtils.accumulateCount(row, "connectionCreated", totalRow);
                RabbitMqUtils.accumulateCount(row, "connectionClosed", totalRow);
                RabbitMqUtils.accumulateCount(row, "channelCreated", totalRow);
                RabbitMqUtils.accumulateCount(row, "channelClosed", totalRow);
            }
            totalRowList.add(totalRow);
            res.put("total", totalRowList);
            return res;
        }
        return null;
    }

    protected Class<RabbitMqConnectionCountStats> getValueType() {
        return RabbitMqConnectionCountStats.class;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public String getName() {
        return "connectionCount";
    }

    protected String primaryKey() {
        return "connection";
    }
}

