/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.consumer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.rabbitmq.RabbitChannelHolder;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqConfig;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.consumer.collector.RabbitMqConsumerCollector;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.ChannelN;
import java.util.Map;
import java.util.Set;

public class BasicCancelInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();
    private final ThreadLocal<Consumer> consumerToRemoveLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            RabbitMqConsumerCollector.initTag();
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent;
                String consumerTag = (String)args[0];
                Map consumerMap = (Map)((AttributeAccess)object).getLopsFileds()[0];
                Consumer consumer = (Consumer)consumerMap.get(consumerTag);
                if (consumer != null) {
                    this.consumerToRemoveLocal.set(consumer);
                }
                if ((spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RabbitMqConsumer")) != null) {
                    spanEvent.addTag("consumerTag", consumerTag);
                }
            }
        }
        catch (Exception rabbitMqCancelException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqCancelException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                RabbitMqConsumerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
            }
            this.hasErrorLocal.set(Boolean.TRUE);
        }
        catch (Exception rabbitMqCancelException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqCancelException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            boolean hasError = false;
            if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                hasError = true;
            }
            this.hasErrorLocal.remove();
            if (!hasError) {
                Set manualAckCustomers;
                String consumerTag = (String)args[0];
                Consumer consumer = this.consumerToRemoveLocal.get();
                if (consumer != null) {
                    RabbitChannelHolder.unregisterChannel(RabbitMqUtils.generateConsumerId(consumerTag, consumer), (ChannelN)object);
                }
                if ((manualAckCustomers = (Set)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"consumersWithManualAck")).remove(consumerTag)) {
                    RabbitMqConfig.decrementManualAckConsumerCount();
                }
            }
            if (RabbitMqConsumerCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
            }
            this.hasErrorLocal.remove();
            this.consumerToRemoveLocal.remove();
        }
        catch (Exception rabbitMqCancelException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)rabbitMqCancelException);
        }
    }
}

