/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.collector.api;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MultiPrimaryKeyAggregator<T extends StatsBase>
extends AbstractPrimaryKeyValueAggregator<PrimaryKey, T> {
    @Override
    protected PrimaryKey defaultKey() {
        int len = this.primaryKeyLength();
        String[] ss = new String[len];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = "default_key_sys";
        }
        return new PrimaryKey(ss);
    }

    protected abstract int primaryKeyLength();

    @Override
    protected T getValue(String ... pks) {
        int c = this.primaryKeyLength();
        if (pks.length != c) {
            throw new RuntimeException("primary key field count must equal with what you defined:" + c + ",actual:" + pks.length);
        }
        PrimaryKey pk = new PrimaryKey(pks);
        return (T)super.getValue(pk);
    }

    @Override
    protected void removeValue(String ... pks) {
        int c = this.primaryKeyLength();
        if (pks.length != c) {
            throw new RuntimeException("primary key field count must equal with what you defined:" + c + ",actual:" + pks.length);
        }
        PrimaryKey pk = new PrimaryKey(pks);
        super.removeValue(pk);
    }

    @Override
    public PrimaryKey getPrimaryKey(Map<String, String> primaryKeyMap) {
        List<String> keys = this.primaryKey();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : keys) {
            String value = primaryKeyMap.get(key);
            if (value == null) {
                throw new ApmRuntimeException("Key " + key + " is null");
            }
            values.add(value);
        }
        return new PrimaryKey(values.toArray(new String[0]));
    }

    @Override
    protected void setPrimaryKey(MonitorDataRow row, PrimaryKey primaryKey) {
        List<String> keys = this.primaryKey();
        for (int i = 0; i < keys.size(); ++i) {
            row.put(keys.get(i), primaryKey.get(i));
        }
    }

    protected abstract List<String> primaryKey();
}

