/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.otel;

import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.otel.OtelEncodingUtils;
import com.lubanops.apm.bootstrap.otel.TemporaryBuffers;

public class SpanId {
    private static final Logger LOG = LogFactory.getLogger();
    private static final int BYTES_LENGTH = 8;
    private static final int HEX_LENGTH = 16;
    private static final String INVALID = "0000000000000000";

    private SpanId() {
    }

    public static int getLength() {
        return 16;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence spanId) {
        return spanId != null && spanId.length() == 16 && !INVALID.contentEquals(spanId) && OtelEncodingUtils.isValidBase16String(spanId);
    }

    public static String fromBytes(byte[] spanIdBytes) {
        if (spanIdBytes != null && spanIdBytes.length >= 8) {
            char[] result = TemporaryBuffers.chars(16);
            OtelEncodingUtils.bytesToBase16(spanIdBytes, result, 8);
            return new String(result, 0, 16);
        }
        LOG.warning("spanIdBytes is null or too short");
        return INVALID;
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return SpanId.getInvalid();
        }
        char[] result = TemporaryBuffers.chars(16);
        OtelEncodingUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }
}

