/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.goldenDB.interceptor;

import com.goldendb.jdbc.PreparedStatement;
import com.goldendb.jdbc.StatementImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.plugin.goldenDB.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.goldenDB.util.GoldenDBTrace;

public class PreparedStatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String preparedSql = preparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(preparedSql, id);
                GoldenDBTrace.onStart(className, methodName, preparedSql, preparedStatement.asSql(), id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "PreparedStatementExecuteUpdateInterceptor error", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                PreparedStatementInteceptor.onError(sql, e);
                GoldenDBTrace.onError(e);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                Integer updateCount = Integer.valueOf(String.valueOf(result));
                MysqlCollector.onFinally((int)updateCount, (int)0);
                GoldenDBTrace.onFinally(updateCount, 0, null);
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

