/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.kafka.consumer;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerConfig;

public class OverrideConsumerIdInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> reformatClientIdLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            boolean needReformat;
            ConsumerConfig config = (ConsumerConfig)object;
            String clientId = config.getString("client.id");
            String groupInstanceId = config.getString("group.instance.id");
            boolean bl = needReformat = (clientId == null || clientId.isEmpty()) && groupInstanceId == null;
            if (needReformat) {
                this.reformatClientIdLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception overrideConsumerIdException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)overrideConsumerIdException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Map configs = (Map)args[0];
            Boolean needReformat = this.reformatClientIdLocal.get();
            if (Boolean.TRUE.equals(needReformat)) {
                this.reformatClientIdLocal.remove();
                String redefinedId = (String)configs.get("client.id");
                if (redefinedId == null) {
                    return;
                }
                int seqIdIndex = redefinedId.lastIndexOf("-");
                if (seqIdIndex >= 0) {
                    int seqId = Integer.parseInt(redefinedId.substring(++seqIdIndex));
                    KafkaHelper.CONSUMERINFO.addReformatIdSeq(redefinedId, String.valueOf(seqId));
                }
            }
        }
        catch (Exception overrideConsumerIdException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)overrideConsumerIdException);
        }
    }
}

