/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.core;

import com.huawei.gaussdb.jdbc.CompatibilityModeEnum;
import com.huawei.gaussdb.jdbc.core.ServerVersion;
import com.huawei.gaussdb.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte element : data) {
            sb.append(Integer.toHexString(element >> 4 & 0xF));
            sb.append(Integer.toHexString(element & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        return str.getBytes(Charset.forName("GB18030-2022".equals(ConnectionFactoryImpl.CLIENT_ENCODING) ? "GB18030" : ConnectionFactoryImpl.CLIENT_ENCODING));
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder((value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new PSQLException(GT.tr("ZERO_BYTES_MAY_NOT_OCCUR_IN_STRING_PARAMS", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch);
                }
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new PSQLException(GT.tr("ZERO_BYTES_MAY_NOT_OCCUR_IN_STRING_PARAMS", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\\' || ch == '\'') {
                        sbuf.append(ch);
                    }
                    sbuf.append(ch);
                }
            }
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value, CompatibilityModeEnum mode) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + (value.length() + 10) / 10 * 11);
        }
        CompatibilityModeEnum targetMode = mode == null ? CompatibilityModeEnum.GAUSS : mode;
        Utils.doAppendEscapedIdentifier(sbuf, value, targetMode.getDefaultIdentifier());
        return sbuf;
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value) throws SQLException {
        return Utils.escapeIdentifier(sbuf, value, CompatibilityModeEnum.GAUSS);
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value, char identifier) throws SQLException {
        try {
            sbuf.append(identifier);
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new PSQLException(GT.tr("ZERO_BYTES_MAY_NOT_OCCUR_IN_THE_IDENTIFIERS", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch == identifier) {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
            sbuf.append(identifier);
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        return ServerVersion.parseServerVersionStr(serverVersion);
    }
}

