/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.fan;

import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanDBNodeStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanEventType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.MasterStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskCnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskGnsType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.TaskMasterDnType;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.ByteConvertUtil;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FanTask {
    private static final int REMOTE_HOST_LENGTH = 128;
    private TaskGnsType gnsType;
    private TaskCnType cnType;
    private TaskMasterDnType taskMasterDnType;
    private FanEventType fanEventType;
    private char reason;
    private MasterStatus priStatus;
    private List<String> remoteHosts = new ArrayList<String>();
    private HostSpec remoteHost;
    private int port;
    private FanDBNodeStatus role;
    private int dnState;
    private String altClusterId;
    private GnsConnection gnsConnection;

    public void setConn(GnsConnection gnsConnection) {
        this.gnsConnection = gnsConnection;
    }

    public GnsConnection getGnsConnection() {
        return this.gnsConnection;
    }

    public TaskGnsType getGnsType() {
        return this.gnsType;
    }

    public TaskCnType getCnType() {
        return this.cnType;
    }

    public void setCnType(TaskCnType cnType) {
        this.cnType = cnType;
    }

    public TaskMasterDnType getTaskMasterDnType() {
        return this.taskMasterDnType;
    }

    public void setTaskMasterDnType(TaskMasterDnType taskMasterDnType) {
        this.taskMasterDnType = taskMasterDnType;
    }

    public FanDBNodeStatus getRole() {
        return this.role;
    }

    public void setRole(FanDBNodeStatus role) {
        this.role = role;
    }

    public List<String> getRemoteHosts() {
        return this.remoteHosts;
    }

    public void setRemoteHosts(List<String> remoteHosts) {
        this.remoteHosts = remoteHosts;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public HostSpec getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(HostSpec remoteHost) {
        this.remoteHost = remoteHost;
    }

    public FanEventType getFanEventType() {
        return this.fanEventType;
    }

    public String getAltClusterId() {
        return this.altClusterId;
    }

    public void setAltClusterId(String altClusterId) {
        this.altClusterId = altClusterId;
    }

    public void setGnsType(TaskGnsType gnsType) {
        this.gnsType = gnsType;
    }

    public void setFanEventType(FanEventType fanEventType) {
        this.fanEventType = fanEventType;
    }

    public char getReason() {
        return this.reason;
    }

    public void setReason(char reason) {
        this.reason = reason;
    }

    public int getDnState() {
        return this.dnState;
    }

    public void setDnState(int dnState) {
        this.dnState = dnState;
    }

    public MasterStatus getPriStatus() {
        return this.priStatus;
    }

    public void setPriStatus(MasterStatus priStatus) {
        this.priStatus = priStatus;
    }

    public void deserialize(byte[] data) throws IOException {
        this.setFanFromStream(new ByteArrayInputStream(data));
    }

    public void setFanFromStream(InputStream bis) throws IOException {
        this.gnsType = ByteConvertUtil.charFrom(bis) == 'F' ? TaskGnsType.GNS_CLOSED : TaskGnsType.GNS_NOT_CLOSED;
        this.fanEventType = FanEventType.of(bis.read());
        this.reason = ByteConvertUtil.charFrom(bis);
        this.priStatus = MasterStatus.of(ByteConvertUtil.charFrom(bis));
        for (int i = 0; i < 3; ++i) {
            String remote = ByteConvertUtil.stringFrom(bis, 128, true);
            if (remote.isEmpty()) continue;
            this.remoteHosts.add(remote);
        }
        this.port = ByteConvertUtil.int4From(bis, true);
        this.role = FanDBNodeStatus.of(ByteConvertUtil.int4From(bis, true));
        this.dnState = bis.read();
    }

    public String toString() {
        return "--------FanEventHeader--------" + System.lineSeparator() + "type: " + (Object)((Object)this.gnsType) + System.lineSeparator() + "fanEventType: " + (Object)((Object)this.fanEventType) + System.lineSeparator() + "priStatus:" + (Object)((Object)this.priStatus) + System.lineSeparator() + "--------FanEventPayload--------" + System.lineSeparator() + "remoteHosts: " + this.remoteHost + System.lineSeparator() + "port: " + this.port + System.lineSeparator() + "role: " + (Object)((Object)this.role) + System.lineSeparator() + "altClusterId:" + this.altClusterId + System.lineSeparator();
    }
}

