/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.reset;

import java.util.Objects;

public class GucParam {
    private String name;
    private String setting;
    private String varType;

    public GucParam(String name, String setting, String varType) {
        this.name = name;
        this.setting = setting;
        this.varType = varType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSetting() {
        return this.setting;
    }

    public void setSetting(String setting) {
        this.setting = setting;
    }

    public String getVarType() {
        return this.varType;
    }

    public void setVarType(String varType) {
        this.varType = varType;
    }

    private String convertToSql() {
        return String.format("set %s='%s'", this.name, this.setting);
    }

    public static String buildGucParams(Iterable<GucParam> gucParams) {
        StringBuilder sb = new StringBuilder();
        sb.append("begin;");
        for (GucParam gucParam : gucParams) {
            sb.append(gucParam.convertToSql()).append(';');
        }
        sb.append("commit;");
        return sb.toString();
    }

    public String toString() {
        return "GucParam{name='" + this.name + '\'' + ", setting='" + this.setting + '\'' + ", varType='" + this.varType + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GucParam)) {
            return false;
        }
        GucParam gucParam = (GucParam)o;
        return Objects.equals(this.name, gucParam.name) && Objects.equals(this.setting, gucParam.setting) && Objects.equals(this.varType, gucParam.varType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.setting, this.varType);
    }
}

