/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.clientlogic;

import com.huawei.gaussdb.jdbc.core.Field;
import com.huawei.gaussdb.jdbc.jdbc.PgResultSet;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.SortColumnMetaData;
import java.sql.SQLException;
import java.util.Comparator;

public class GroupByComparator
implements Comparator<byte[][]> {
    private SortColumnMetaData[] groupList;
    private PgResultSet resultSet;

    public GroupByComparator(SortColumnMetaData[] groupByList, PgResultSet result) {
        this.groupList = groupByList;
        this.resultSet = result;
    }

    @Override
    public int compare(byte[][] p1, byte[][] p2) {
        int cmp = 0;
        if (this.groupList != null) {
            SortColumnMetaData element;
            for (int sortElem = 0; sortElem < this.groupList.length && (cmp = this.compareInner(p1, p2, element = this.groupList[sortElem])) == 0; ++sortElem) {
            }
        }
        return cmp;
    }

    private int compareInner(byte[][] p1, byte[][] p2, SortColumnMetaData element) {
        for (int i = 0; i < this.resultSet.getFields().length; ++i) {
            boolean isSecondNull;
            Field field = this.resultSet.getFields()[i];
            String fieldName = field.getColumnLabel();
            if (!fieldName.equals(element.getColumn()) && !fieldName.equals(element.getAlias())) continue;
            boolean isFirstNull = p1[i] == null || p1[i].length == 0;
            boolean bl = isSecondNull = p2[i] == null || p2[i].length == 0;
            if (isFirstNull && isSecondNull) {
                return 0;
            }
            if (isFirstNull && !isSecondNull) {
                return 1;
            }
            if (!isFirstNull && isSecondNull) {
                return -1;
            }
            try {
                return this.resultSet.compareValues(p1[i], p2[i], field, true);
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }
}

