/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.qos;

import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.qos.RTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataProcess {
    private static Log LOGGER = Logger.getLogger(DataProcess.class.getName());
    private static Log fileLogger = Logger.getLogger("com.huawei.dbMonitor.qos");
    private static final int DATA_SIZE = 10;
    private static final int TIME_INTERVAL = 1000;
    private static final String OS_TYPE = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    private static final long NANO_TO_MILL = 1000000L;
    private static final String PACKET = "AAAAAAAAA";
    private static final Pattern WIN_PATTERN = Pattern.compile("(\\d+)\\s+(\\d+)");
    private static final Pattern LINUX_PATTERN = Pattern.compile("^\\s*([^:]+):");
    private RTO rto = new RTO();
    private List<Long> delayList = new ArrayList<Long>();
    private List<Boolean> lostList = new ArrayList<Boolean>();
    private double averageDelay;
    private double jitter;
    private double lossRate;
    private double downloadSpeed;
    private double uploadSpeed;
    private long validPacket = 0L;
    private InetAddress dstInetAddress;
    private int dstPort;
    private int connectTimeout;
    private int minPacketLossTimeout = 1000;

    DataProcess(InetAddress dstHost, int port, int connectTimeout) {
        this.dstInetAddress = dstHost;
        this.dstPort = port;
        if (connectTimeout > this.minPacketLossTimeout) {
            this.minPacketLossTimeout = connectTimeout;
        }
        this.connectTimeout = connectTimeout == 0 ? 2000 : connectTimeout;
    }

    public void monitor() {
        long delay = this.getDelay();
        if (this.delayList.size() == 10) {
            this.delayList.remove(0);
            this.lostList.remove(0);
        }
        this.delayList.add(delay);
        this.dataAnalyze();
        this.saveQosResult();
    }

    private void dataAnalyze() {
        int validDelayCount = 0;
        long totalDelaySum = 0L;
        for (Long delay : this.delayList) {
            if (delay <= 0L || delay >= (long)this.minPacketLossTimeout * 1000000L) continue;
            totalDelaySum += delay.longValue();
            ++validDelayCount;
        }
        long latestDelay = this.delayList.get(this.delayList.size() - 1);
        if (latestDelay < 0L) {
            this.lostList.add(Boolean.TRUE);
        } else {
            boolean isPacketLoss = this.validPacket == 0L ? latestDelay >= (long)this.minPacketLossTimeout * 1000000L : (double)latestDelay >= this.rto.getRTO() * 1000000.0;
            this.lostList.add(isPacketLoss);
        }
        int countOfLoss = 0;
        for (Boolean isLoss : this.lostList) {
            if (!isLoss.booleanValue()) continue;
            ++countOfLoss;
        }
        this.lossRate = (double)countOfLoss / (double)this.lostList.size() * 100.0;
        if (latestDelay > 0L && latestDelay < (long)this.minPacketLossTimeout * 1000000L) {
            this.rto.update((double)latestDelay / 1000000.0, ++this.validPacket);
        }
        if (validDelayCount <= 0) {
            this.averageDelay = -1.0;
            this.jitter = -1.0;
            return;
        }
        this.averageDelay = (double)totalDelaySum / ((double)validDelayCount * 1000000.0);
        double jitterSum = 0.0;
        for (Long delay : this.delayList) {
            if (delay <= 0L || delay >= (long)this.minPacketLossTimeout * 1000000L) continue;
            jitterSum += ((double)delay.longValue() / 1000000.0 - this.averageDelay) * ((double)delay.longValue() / 1000000.0 - this.averageDelay);
        }
        this.jitter = Math.sqrt(jitterSum / (double)validDelayCount);
        this.calculateNetSpeed();
    }

    private void saveQosResult() {
        String builder = "{" + System.lineSeparator() + "   \"Destination host:port\" : \"" + this.dstInetAddress.getHostAddress() + ":" + this.dstPort + "\"," + System.lineSeparator() + "   \"Delay\" : \"" + String.format("%.2f", this.averageDelay) + " ms\"," + System.lineSeparator() + "   \"Jitter\" : \"" + String.format("%.2f", this.jitter) + "ms\"," + System.lineSeparator() + "   \"Loss\" : \"" + String.format(Locale.ROOT, "%d", (int)this.lossRate) + "%\"," + System.lineSeparator() + "   \"DownloadSpeed\" : \"" + String.format("%.3f", this.downloadSpeed) + "Mbps\"," + System.lineSeparator() + "   \"UpLoadSpeed\" : \"" + String.format("%.3f", this.uploadSpeed) + "Mbps\"" + System.lineSeparator() + "}" + System.lineSeparator();
        fileLogger.debug(builder);
    }

    public int getTimeInterval() {
        return 1000;
    }

    private long getDelay() {
        long delaySeconds = -1L;
        try (Socket socket = this.createSocket();){
            long sendTime = System.nanoTime();
            socket.connect(new InetSocketAddress(this.dstInetAddress, this.dstPort), this.connectTimeout);
            if (socket.isConnected()) {
                long receiveTime = this.getReceiveTime(socket);
                delaySeconds = receiveTime - sendTime;
            }
        }
        catch (IOException e) {
            LOGGER.error("FAILURE - Cannot connect to " + this.dstInetAddress.getHostAddress() + ":" + this.dstPort + " within socketTimeout " + this.connectTimeout + "!." + e);
        }
        return delaySeconds;
    }

    private void calculateNetSpeed() {
        this.downloadSpeed = -1.0;
        this.uploadSpeed = -1.0;
        if (OS_TYPE.contains("windows")) {
            this.downloadSpeed = this.getSpeedWindows(true);
            this.uploadSpeed = this.getSpeedWindows(false);
        } else if (OS_TYPE.contains("linux")) {
            this.downloadSpeed = this.getSpeedLinux(true);
            this.uploadSpeed = this.getSpeedLinux(false);
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("UnSupported system!");
        }
    }

    private double getSpeedWindows(boolean isReceive) {
        long sendFirst;
        block2: {
            sendFirst = this.getSendByteWindows(isReceive);
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("Time InterruptedException error. Error message: ", e);
            }
        }
        long sendSecond = this.getSendByteWindows(isReceive);
        return (double)(sendSecond - sendFirst) / 1048576.0;
    }

    private long getSendByteWindows(boolean isReceive) {
        String netstatOutput;
        block4: {
            netstatOutput = null;
            try {
                netstatOutput = DataProcess.runCommand();
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("runCommand error. Error message: ", e);
            }
        }
        Matcher matcher = WIN_PATTERN.matcher(netstatOutput);
        if (isReceive && matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        if (!isReceive && matcher.find()) {
            return Long.parseLong(matcher.group(2));
        }
        return 0L;
    }

    private static String runCommand() throws IOException {
        Process process = Runtime.getRuntime().exec("netstat -e");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            String string = output.toString();
            return string;
        }
    }

    private double getSpeedLinux(boolean isReceive) {
        double speed;
        block16: {
            speed = 0.0;
            try (Socket socket = this.createSocket();){
                socket.connect(new InetSocketAddress(this.dstInetAddress, this.dstPort), this.connectTimeout);
                if (socket.isConnected()) {
                    InetAddress localAddress = socket.getLocalAddress();
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localAddress);
                    String interfaceName = networkInterface.getName();
                    long bytesPerRecv = 0L;
                    long bytesPerSec = 0L;
                    bytesPerSec = DataProcess.getBytesFromIfconfigOutput(interfaceName, isReceive);
                    TimeUnit.MILLISECONDS.sleep(1000L);
                    bytesPerRecv = DataProcess.getBytesFromIfconfigOutput(interfaceName, isReceive);
                    speed = (double)(bytesPerRecv - bytesPerSec) * 8.0 / 1048576.0;
                }
            }
            catch (IOException e) {
                LOGGER.error("FAILURE - Cannot connect to " + this.dstInetAddress.getHostAddress() + ":" + this.dstPort + " within socketTimeout " + this.connectTimeout + "!." + e);
            }
            catch (InterruptedException e) {
                if (!LOGGER.isErrorEnabled()) break block16;
                LOGGER.error("Time InterruptedException error. Error message: ", e);
            }
        }
        return speed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getBytesFromIfconfigOutput(String interfaceName, boolean isReceive) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(Paths.get("/proc/net/dev", new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            String[] parts;
            String line;
            Matcher matcher;
            do {
                if ((line = reader.readLine()) == null) return 0L;
            } while (!(matcher = LINUX_PATTERN.matcher(line)).find() || !interfaceName.equals(matcher.group(1)) || (parts = line.trim().split("\\s+")).length < 10);
            long l = isReceive ? Long.parseLong(parts[1]) : Long.parseLong(parts[9]);
            return l;
        }
        catch (IOException e) {
            LOGGER.error("File read /proc/net/dev failed, please check the file is existed or if get the permission" + e);
        }
        return 0L;
    }

    private Socket createSocket() throws IOException {
        Socket socket = new Socket();
        InetSocketAddress localSocketAddr = new InetSocketAddress(0);
        socket.bind(localSocketAddr);
        return socket;
    }

    private long getReceiveTime(Socket socket) throws IOException {
        try (OutputStream outputStream = socket.getOutputStream();){
            outputStream.write(PACKET.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            socket.shutdownOutput();
            long l = System.nanoTime();
            return l;
        }
    }

    public String toString() {
        return "DataProcess{dstInetAddress=" + this.dstInetAddress + ", dstPort=" + this.dstPort + '}';
    }
}

