/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.auth.signer;

import com.huawei.shade.com.cloud.sdk.ClientException;
import com.huawei.shade.com.cloud.sdk.Request;
import com.huawei.shade.com.cloud.sdk.WebServiceRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.credentials.Credentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SigningAlgorithm;
import com.huawei.shade.com.cloud.sdk.internal.SdkDigestInputStream;
import com.huawei.shade.com.cloud.sdk.util.Base64;
import com.huawei.shade.com.cloud.sdk.util.HttpUtils;
import com.huawei.shade.com.cloud.sdk.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractSigner
implements Signer {
    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) throws ClientException {
        return this.signAndBase64Encode(data.getBytes(StringUtils.UTF8), key, algorithm);
    }

    protected String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) throws ClientException {
        try {
            byte[] signature = this.sign(data, key.getBytes(StringUtils.UTF8), algorithm);
            return Base64.encodeAsString(signature);
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws ClientException {
        try {
            byte[] data = stringData.getBytes(StringUtils.UTF8);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws ClientException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new ClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public byte[] hash(String text) throws ClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StringUtils.UTF8));
            return md.digest();
        }
        catch (Exception e) {
            throw new ClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected byte[] hash(InputStream input) throws ClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            SdkDigestInputStream digestInputStream = new SdkDigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new ClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public byte[] hash(byte[] data) throws ClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new ClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            sorted.put(HttpUtils.urlEncode(key, false), HttpUtils.urlEncode(value, false));
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            builder.append(pair.getKey());
            builder.append("=");
            builder.append(pair.getValue());
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    protected String getCanonicalizedQueryString(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return this.getCanonicalizedQueryString(request.getParameters());
    }

    protected byte[] getBinaryRequestPayload(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.encodeParameters(request);
            if (encodedParameters == null) {
                return new byte[0];
            }
            return encodedParameters.getBytes(StringUtils.UTF8);
        }
        return this.getBinaryRequestPayloadWithoutQueryParams(request);
    }

    protected String getRequestPayload(Request<?> request) {
        return this.newString(this.getBinaryRequestPayload(request));
    }

    protected String getRequestPayloadWithoutQueryParams(Request<?> request) {
        return this.newString(this.getBinaryRequestPayloadWithoutQueryParams(request));
    }

    protected byte[] getBinaryRequestPayloadWithoutQueryParams(Request<?> request) {
        InputStream content = this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int bytesRead;
            WebServiceRequest req = request.getOriginalRequest();
            content.mark(req == null ? -1 : req.getReadLimit());
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[5120];
            while ((bytesRead = content.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            content.reset();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new ClientException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    throw new ClientException("Unable to close byteArrayOutputStream: " + e.getMessage(), e);
                }
            }
        }
    }

    protected InputStream getBinaryRequestPayloadStream(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.encodeParameters(request);
            if (encodedParameters == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return new ByteArrayInputStream(encodedParameters.getBytes(StringUtils.UTF8));
        }
        return this.getBinaryRequestPayloadStreamWithoutQueryParams(request);
    }

    protected InputStream getBinaryRequestPayloadStreamWithoutQueryParams(Request<?> request) {
        try {
            InputStream is = request.getContent();
            if (is == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (!is.markSupported()) {
                throw new ClientException("Unable to read request payload to sign request.");
            }
            return is;
        }
        catch (Exception e) {
            throw new ClientException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedResourcePath(String resourcePath) {
        return this.getCanonicalizedResourcePath(resourcePath, true);
    }

    protected String getCanonicalizedResourcePath(String resourcePath, boolean urlEncode) {
        String value;
        if (resourcePath == null || resourcePath.isEmpty()) {
            return "/";
        }
        String string = value = urlEncode ? HttpUtils.urlEncode(resourcePath, true) : resourcePath;
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    protected String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = endpoint.getHost().toLowerCase();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    protected Credentials sanitizeCredentials(Credentials credentials) {
        String accessKeyId = credentials.getAccessKeyId();
        String secretKey = credentials.getSecretKey();
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        return new BasicCredentials(accessKeyId, secretKey);
    }

    protected String newString(byte[] bytes) {
        return new String(bytes, StringUtils.UTF8);
    }

    protected Date getSignatureDate(int offsetInSeconds) {
        return new Date(System.currentTimeMillis() - (long)(offsetInSeconds * 1000));
    }
}

