/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.org.apache.http.client.protocol;

import com.huawei.shade.org.apache.http.HttpEntity;
import com.huawei.shade.org.apache.http.HttpEntityEnclosingRequest;
import com.huawei.shade.org.apache.http.HttpException;
import com.huawei.shade.org.apache.http.HttpRequest;
import com.huawei.shade.org.apache.http.HttpRequestInterceptor;
import com.huawei.shade.org.apache.http.HttpVersion;
import com.huawei.shade.org.apache.http.ProtocolVersion;
import com.huawei.shade.org.apache.http.annotation.Contract;
import com.huawei.shade.org.apache.http.annotation.ThreadingBehavior;
import com.huawei.shade.org.apache.http.client.config.RequestConfig;
import com.huawei.shade.org.apache.http.client.protocol.HttpClientContext;
import com.huawei.shade.org.apache.http.protocol.HttpContext;
import com.huawei.shade.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

