/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector.commons;

import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RedisTransformHelper {
    public static final String FILTER_REGEX_SENTINEL = "sentinel";
    public static final String FILTER_REGEX_CLUSTER = "cluster";
    public static final int COLLECTOR_CAPACITY = 20;
    public static final Pattern INTEGER_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");
    public static final int BLOB_THRESHOLD = 1024;
    public static final Set<String> NOT_INTERCEPTOR_METHOD_NAMES = new HashSet<String>(Arrays.asList("close", "close", "setdatasource", "sentinelgetmasteraddrbyname", "subscribe", "publish", "psubscribe", "dump", "restore", "pubsubchannels", "pubsubnumpat", "pubsubnumsub", "connect", "auth", "getdb", "resetstate", "disconnect", "quit", "getclient", "ping", "isconnected", "checkisinmultiorpipeline", "setclient", "isinmulti", "isinwatch", "clear", "pipelined", "setpassword", "setdb", "getclusternodes", "getconnectionfromslot", "checkisinmultiorpipeline", "isbroken"));
    public static final Set<String> INTERCEPTOR_METHOD_SET = new HashSet<String>(Arrays.asList("set", "setnx", "getset", "hmset", "setex", "setbit", "setrange", "lset", "hsetnx", "get", "hgetall", "getbit", "getrange", "lpop", "rpop", "spop", "exists", "del", "smembers", "mget", "mset", "rpush", "lpush", "lpushx", "rpushx", "eval", "expire", "pexpire", "hget", "hmget", "hset"));
    public static final Set<String> HIT_METHOD_SET = new HashSet<String>(Arrays.asList("getset", "get", "getbit", "getrange", "lpop", "rpop", "spop", "exists", "del", "smembers", "mget", "expire", "hget", "hmget", "set", "mset", "hset", "hmset"));
    private static final Set NORMAL_MATCH_KEY = new HashSet<String>(Arrays.asList("getset", "get", "hget", "lpop", "rpop", "spop"));
    private static final Set SEC_MATCH_KEY = new HashSet<String>(Arrays.asList("gsmembersetset", "smembers", "hmget"));
    public static final Set<String> OPERATION_MAPPING_WRITE = new HashSet<String>(Arrays.asList("getset", "set", "setbit", "setex ", "setnx ", "setrange", "strlen ", "mset", "msetnx ", "psetex", "incr ", "incrby ", "incrbyfloat", "decr ", "decrby ", "append ", "hmset", "hset", "hsetnx ", "hincrby", "hincrbyfloat", "hdel", "rpoplpush", "rpush", "rpushx", "lpush", "lpushx", "lrem", "ltrim", "lset", "brpoplpush", "linsert", "sadd", "sdiff", "sdiffstore", "sinterstore", "sismember", "srem", "sunion", "sunionstore", "sinter", "zadd", "zincrby", "zinterstore", "zrange", "zrangebylex", "zrangebyscore", "zrank", "zrem", "zremrangebylex", "zremrangebyrank", "zremrangebyscore", "zrevrange", "zrevrangebyscore", "zrevrank", "zunionstore", "xadd", "xdel", "del", "xtrim"));
    public static final Set<String> OPERATION_MAPPING_READ = new HashSet<String>(Arrays.asList("getrange", "getbit ", "mget", "hvals", "hkeys", "hlen", "hexists", "hget", "hgetall", "hmget", "blpop", "brpop", "lindex", "llen", "lpop", "lrange", "rpop", "scard", "srandmember", "spop", "sscan", "smove", "zlexcount", "zscore", "zscan", "zcard", "zcount", "xget", "get", "xread", "xlen", "xrange", "xrevrange", "smembers"));

    public static boolean needParseBody(String method) {
        return INTERCEPTOR_METHOD_SET.contains(method.toLowerCase());
    }

    public static boolean isHitMethod(String method) {
        return HIT_METHOD_SET.contains(method.toLowerCase());
    }

    public static String normalizeList(List<String> nodes) {
        StringBuilder sBuilder = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            String s = nodes.get(i);
            s = s.replace("redis://", "");
            sBuilder.append(s);
            if (i >= nodes.size() - 1) continue;
            sBuilder.append(",");
        }
        return sBuilder.toString();
    }

    public static boolean isHit(Object result, String methodName, String reply) {
        boolean hit = Boolean.FALSE;
        methodName = methodName.toLowerCase();
        if (StringUtils.isBlank((String)reply)) {
            return hit;
        }
        if (RedisTransformHelper.normalMatch(methodName)) {
            hit = RedisTransformHelper.matchKeyword(reply, "nil");
        } else if ("getbit".equals(methodName) || "exists".equals(methodName)) {
            hit = "0".equals(reply) || "false".equals(reply) ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
        } else if ("getrange".equals(methodName)) {
            hit = RedisTransformHelper.matchKeyword(reply, "$0");
        } else if ("del".equals(methodName)) {
            RedisTransformHelper.delIsHit(reply);
        } else if (SEC_MATCH_KEY.contains(methodName.toLowerCase())) {
            RedisTransformHelper.colletionIsHit(result);
        } else if ("expire".equals(methodName)) {
            hit = RedisTransformHelper.expireIsHit(reply);
        } else if ("set".equals(methodName) || "hmset".equals(methodName)) {
            if ("OK".equals(reply)) {
                hit = Boolean.TRUE;
            }
        } else if ("hset".equals(methodName)) {
            hit = RedisTransformHelper.hsetIsHit(reply);
        }
        return hit;
    }

    private static Boolean delIsHit(String reply) {
        boolean hit = Boolean.FALSE;
        if (StringUtils.isBlank((String)reply) || Long.parseLong(reply) > 0L) {
            hit = Boolean.TRUE;
        }
        return hit;
    }

    private static Boolean colletionIsHit(Object result) {
        boolean hit = Boolean.FALSE;
        if (result != null && result instanceof Collection && ((Collection)result).size() > 0) {
            hit = Boolean.TRUE;
        }
        return hit;
    }

    private static Boolean hsetIsHit(String reply) {
        boolean hit = Boolean.FALSE;
        if ("0".equals(reply) || "1".equals(reply)) {
            hit = Boolean.TRUE;
        }
        return hit;
    }

    private static Boolean expireIsHit(String reply) {
        boolean hit = Boolean.FALSE;
        if (reply == null || reply.length() == 0) {
            hit = Boolean.FALSE;
        } else if ("true".equals(reply)) {
            hit = Boolean.TRUE;
        } else if ("false".equals(reply)) {
            hit = Boolean.FALSE;
        } else if (RedisTransformHelper.isInteger(reply)) {
            hit = Integer.parseInt(reply) == 1 ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        }
        return hit;
    }

    private static boolean normalMatch(String methodName) {
        return NORMAL_MATCH_KEY.contains(methodName.toLowerCase());
    }

    private static boolean matchKeyword(String reply, String nil) {
        boolean hit = StringUtils.isBlank((String)reply) || reply.contains(nil) ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
        return hit;
    }

    public static boolean isInteger(String str) {
        return INTEGER_PATTERN.matcher(str).matches();
    }
}

