/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.ConversionUtils;
import com.taobao.arthas.core.command.model.MethodNode;
import com.taobao.arthas.core.command.model.ThreadNode;
import com.taobao.arthas.core.command.model.ThrowNode;
import com.taobao.arthas.core.command.model.TraceModel;
import com.taobao.arthas.core.command.model.TraceNode;

public class TraceModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    public static PDebuggerResponse convert(TraceModel traceModel, PDebuggerRequest request) {
        PDebuggerResponse.TraceResponse.Builder traceResponseBuilder = PDebuggerResponse.TraceResponse.newBuilder().setNodeCount(traceModel.getNodeCount()).setRoot(TraceModelToPDebuggerResponseConverter.traceWalker(traceModel.getRoot(), request.getPayload().getTraceCommand().getClassPattern(), request.getPayload().getTraceCommand().getMethodPattern()));
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setTraceResponse(traceResponseBuilder.build());
        return TraceModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static PDebuggerResponse.TraceResponse.TraceNode traceWalker(TraceNode traceNode, String clazz, String method) {
        PDebuggerResponse.TraceResponse.TraceNode.Builder traceNodeBuilder = PDebuggerResponse.TraceResponse.TraceNode.newBuilder();
        if (MethodNode.class.isAssignableFrom(traceNode.getClass())) {
            traceNodeBuilder.setMethodNode(TraceModelToPDebuggerResponseConverter.handleMethodNode((MethodNode)traceNode, clazz, method));
        } else if (ThrowNode.class.isAssignableFrom(traceNode.getClass())) {
            traceNodeBuilder.setThrowNode(TraceModelToPDebuggerResponseConverter.handleThrowNode((ThrowNode)traceNode, clazz, method));
        } else if (ThreadNode.class.isAssignableFrom(traceNode.getClass())) {
            traceNodeBuilder.setThreadNode(TraceModelToPDebuggerResponseConverter.handleThreadNode((ThreadNode)traceNode, clazz, method));
        }
        return traceNodeBuilder.build();
    }

    private static PDebuggerResponse.TraceResponse.MethodNode handleMethodNode(MethodNode methodNode, String clazz, String method) {
        PDebuggerResponse.TraceResponse.MethodNode.Builder methodNodeBuilder = PDebuggerResponse.TraceResponse.MethodNode.newBuilder();
        methodNodeBuilder.setMethodName(methodNode.getMethodName()).setClassName(methodNode.getClassName()).setLineNumber(methodNode.getLineNumber()).setIsThrow(methodNode.getThrow() == null ? false : methodNode.getThrow()).setThrowExp(methodNode.getThrowExp() == null ? "" : methodNode.getThrowExp()).setCost(methodNode.getCost()).setType("method");
        if (!ConversionUtils.isEmpty(methodNode.getChildren())) {
            for (TraceNode child : methodNode.getChildren()) {
                methodNodeBuilder.addChildren(TraceModelToPDebuggerResponseConverter.traceWalker(child, clazz, method));
            }
        }
        return methodNodeBuilder.build();
    }

    private static PDebuggerResponse.TraceResponse.ThrowNode handleThrowNode(ThrowNode throwNode, String clazz, String method) {
        PDebuggerResponse.TraceResponse.ThrowNode.Builder throwNodeBuilder = PDebuggerResponse.TraceResponse.ThrowNode.newBuilder();
        throwNodeBuilder.setException(throwNode.getException()).setMessage(throwNode.getMessage()).setLineNumber(throwNode.getLineNumber()).setType("throw");
        if (!ConversionUtils.isEmpty(throwNode.getChildren())) {
            for (TraceNode child : throwNode.getChildren()) {
                throwNodeBuilder.addChildren(TraceModelToPDebuggerResponseConverter.traceWalker(child, clazz, method));
            }
        }
        return throwNodeBuilder.build();
    }

    private static PDebuggerResponse.TraceResponse.ThreadNode handleThreadNode(ThreadNode threadNode, String clazz, String method) {
        PDebuggerResponse.TraceResponse.ThreadNode.Builder threadNodeBuilder = PDebuggerResponse.TraceResponse.ThreadNode.newBuilder();
        threadNodeBuilder.setThreadName(threadNode.getThreadName()).setThreadId(threadNode.getThreadId()).setDaemon(threadNode.isDaemon()).setType("thread");
        if (!ConversionUtils.isEmpty(threadNode.getChildren())) {
            for (TraceNode child : threadNode.getChildren()) {
                if (!TraceModelToPDebuggerResponseConverter.isCorrectChild(child, clazz, method)) continue;
                threadNodeBuilder.addChildren(TraceModelToPDebuggerResponseConverter.traceWalker(child, clazz, method));
            }
        }
        return threadNodeBuilder.build();
    }

    private static boolean isCorrectChild(TraceNode traceNode, String clazz, String method) {
        if (MethodNode.class.isAssignableFrom(traceNode.getClass())) {
            MethodNode methodNode = (MethodNode)traceNode;
            return methodNode.getClassName().equals(clazz) && methodNode.getMethodName().equals(method);
        }
        return true;
    }
}

