/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.lubanops.apm.integration.debugger.converters.JadModelToPDebuggerResponseConverter;
import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.job.AbstractJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import com.lubanops.apm.integration.debugger.service.message.command.JadCommand;
import com.taobao.arthas.core.command.model.JadModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.distribution.PackingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.shell.session.Session;

public class JadJob
extends AbstractJob {
    private DebuggerCommandHandler debugCommandHandler;
    private Session session;
    private JadCommand jadCommand;

    public JadJob(DebuggerCommandHandler debuggerCommandHandler) {
        this.debugCommandHandler = debuggerCommandHandler;
        this.session = this.debugCommandHandler.getSession();
        this.jadCommand = new JadCommand();
    }

    @Override
    public CommandType getType() {
        return CommandType.JAD_COMMAND;
    }

    @Override
    public PDebuggerResponse handleRequest(PDebuggerRequest request) {
        PackingResultDistributorImpl packingResultDistributor = new PackingResultDistributorImpl(this.session);
        Requests.JadArguments args = new Requests.JadArguments();
        args.setClassPattern(request.getPayload().getJadCommand().getClassPattern());
        args.setMethodPattern(request.getPayload().getJadCommand().getMethodName());
        args.setHashClassLoader(request.getPayload().getJadCommand().getCode());
        ArthasDebuggerCommand arthasDebuggerCommand = this.jadCommand.buildArthasCommand(args);
        if (!arthasDebuggerCommand.getSuccess().booleanValue()) {
            return ArthasModelToPDebuggerConverter.createFailureResponse(request, new StatusModel(1, arthasDebuggerCommand.getErrorMsg()), false);
        }
        Boolean expired = this.debugCommandHandler.handle(arthasDebuggerCommand.getCommand(), (PackingResultDistributor)packingResultDistributor);
        StatusModel statusModel = null;
        for (ResultModel result : packingResultDistributor.getResults()) {
            if (result instanceof JadModel) {
                return JadModelToPDebuggerResponseConverter.convert((JadModel)result, request);
            }
            if (!(result instanceof StatusModel)) continue;
            statusModel = (StatusModel)result;
        }
        return ArthasModelToPDebuggerConverter.createFailureResponse(request, statusModel, expired);
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

