/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.StringUtils;

public class WatchCommand
extends AbstractMessageProvider<WatchCommand> {
    @Override
    public Class<WatchCommand> getType() {
        return WatchCommand.class;
    }

    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.WatchArguments args = (Requests.WatchArguments)commandArguments;
        return this.toCommandLine(args);
    }

    private ArthasDebuggerCommand toCommandLine(Requests.WatchArguments args) {
        StringBuilder sb = new StringBuilder("watch ");
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        sb.append(args.getClassPattern());
        if (StringUtils.isBlank((CharSequence)args.getMethodPattern())) {
            return new ArthasDebuggerCommand("", "Method pattern must have a value", false);
        }
        sb.append(" " + args.getMethodPattern());
        this.addOgnl(sb, args.getExpression(), args.getCondition());
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }

    private void addOgnl(StringBuilder sb, String expression, String conditionExpression) {
        if (expression == null && conditionExpression == null) {
            sb.append(" \"{params, returnObj, throwExp, target}\" \"\"  -n 1 -x 2");
            return;
        }
        sb.append(" \"{params, returnObj, throwExp, target");
        if (!StringUtils.isBlank((CharSequence)expression)) {
            sb.append(", " + expression + "}\"");
        } else {
            sb.append("}\"");
        }
        if (!StringUtils.isBlank((CharSequence)conditionExpression)) {
            sb.append(" \"" + conditionExpression + "\"");
        } else {
            sb.append(" \"\"");
        }
        sb.append(" -n 1 -x 2");
    }
}

