/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mybatis.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.collector.MybatisIdThreadLocal;
import java.util.HashMap;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

public class MybatisInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            MappedStatement ms;
            if (args.length > 1 && args[0] instanceof MappedStatement && MybatisIdThreadLocal.THREAD_LOCAL.get() == null && !((ms = (MappedStatement)args[0]).getSqlSource() instanceof ProviderSqlSource)) {
                BoundSql boundSql = ms.getBoundSql(args[1]);
                String sql = boundSql.getSql();
                if (sql.length() > MysqlCollector.CONFIG.getSqlSize()) {
                    sql = sql.substring(0, MysqlCollector.CONFIG.getSqlSize());
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(sql, ms.getId());
                MybatisIdThreadLocal.THREAD_LOCAL.set(map);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "mybatis interceptor error", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object o, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (args.length > 1 && args[0] instanceof MappedStatement) {
                MybatisIdThreadLocal.THREAD_LOCAL.set(null);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "mybatis interceptor error", (Throwable)ex);
        }
    }
}

