/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.gc;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.collector.gc.JVMGcCollector;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class GCMbeanNotification {
    private static final long BYTE2KB = 1024L;
    private static final long START_TIME = ManagementFactory.getRuntimeMXBean().getStartTime();

    public static void init() {
        try {
            List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean gcBean : gcBeans) {
                NotificationEmitter emitter = (NotificationEmitter)((Object)gcBean);
                NotificationListener listener = new NotificationListener(){

                    @Override
                    public void handleNotification(Notification notification, Object object) {
                        GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                        GcInfo ccInfo = info.getGcInfo();
                        long duration = ccInfo.getDuration();
                        String msg = GCMbeanNotification.getGcDetail(ccInfo, duration);
                        JVMGcCollector.onCount(info, msg, duration);
                    }
                };
                emitter.addNotificationListener(listener, new NotificationFilter(){

                    @Override
                    public boolean isNotificationEnabled(Notification notification) {
                        return notification.getType().equals("com.sun.management.gc.notification");
                    }
                }, null);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "gc notice register failed", (Throwable)e);
        }
    }

    private static String getGcDetail(GcInfo ccInfo, long duration) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder detail = new StringBuilder();
        detail.append("starttime:").append(dateFormat.format(new Date(START_TIME + ccInfo.getStartTime()))).append("\r\n");
        detail.append("endTime:").append(dateFormat.format(new Date(START_TIME + ccInfo.getEndTime()))).append("\r\n");
        detail.append("duration:").append(duration).append("ms").append("\r\n");
        Map<String, MemoryUsage> beforeUsageMap = ccInfo.getMemoryUsageBeforeGc();
        Map<String, MemoryUsage> afterUsageMap = ccInfo.getMemoryUsageAfterGc();
        for (Map.Entry<String, MemoryUsage> entry : afterUsageMap.entrySet()) {
            String name = entry.getKey();
            MemoryUsage afterUsage = entry.getValue();
            MemoryUsage beforeUsage = beforeUsageMap.get(name);
            detail.append("[").append(name).append("]").append("init:").append(afterUsage.getInit() / 1024L).append("K;").append("max:").append(afterUsage.getMax() / 1024L).append("K;").append("used:").append(beforeUsage.getUsed() / 1024L).append("K->").append(afterUsage.getUsed() / 1024L).append("K;").append("committed:").append(beforeUsage.getCommitted() / 1024L).append("K->").append(afterUsage.getCommitted() / 1024L).append("K;").append("\r\n");
        }
        return detail.toString();
    }
}

