/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.consumer.stats.RocketMqConsumeStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RocketMqClientIdConsumeAggregator
extends MultiPrimaryKeyAggregator<RocketMqConsumeStats> {
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<RocketMqConsumeStats> statsLocal = new ThreadLocal();

    public void incrementConsumedMsgCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedMsgCount(count);
        }
    }

    public void incrementConsumedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedBytesCount(count);
        }
    }

    public void incrementReconsumeTimes(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementReconsumeTimes(count);
        }
    }

    public void onStart(String clientId, String group) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = (RocketMqConsumeStats)this.getValue(new String[]{clientId, group});
        stats.setClientId(clientId);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalConsumedMsgCount = 0L;
        long totalConsumedBytes = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        long totalReconsumeTimes = 0L;
        long totalOffsetDiff = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                long invokeCount = RocketMqUtils.getLongValElseZero(row, "invokeCount");
                long consumedMsgCount = RocketMqUtils.getLongValElseZero(row, "consumedMsgCount");
                long consumedBytes = RocketMqUtils.getLongValElseZero(row, "consumedBytes");
                long errorCount = RocketMqUtils.getLongValElseZero(row, "errorCount");
                long totalTime = RocketMqUtils.getLongValElseZero(row, "totalTime");
                long reconsumeTimes = RocketMqUtils.getLongValElseZero(row, "reconsumeTimes");
                long offsetDiff = RocketMqUtils.getLongValElseZero(row, "offsetDiff");
                totalInvokeCount += invokeCount;
                totalConsumedMsgCount += consumedMsgCount;
                totalConsumedBytes += consumedBytes;
                totalErrorCount += errorCount;
                totalTotalTime += totalTime;
                totalReconsumeTimes += reconsumeTimes;
                totalOffsetDiff += offsetDiff;
            }
        }
        if (totalOffsetDiff < 0L) {
            totalOffsetDiff = -1L;
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"consumeInvokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"consumedMsgCount", (Object)totalConsumedMsgCount);
        totalRow.put((Object)"consumedBytes", (Object)totalConsumedBytes);
        totalRow.put((Object)"consumeErrorCount", (Object)totalErrorCount);
        totalRow.put((Object)"consumeTotalTime", (Object)totalTotalTime);
        totalRow.put((Object)"reconsumeTimes", (Object)totalReconsumeTimes);
        totalRow.put((Object)"offsetDiff", (Object)totalOffsetDiff);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("clientId", "group");
    }

    protected Class<RocketMqConsumeStats> getValueType() {
        return RocketMqConsumeStats.class;
    }

    public String getName() {
        return "clientIdConsume";
    }
}

