/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transaction;

import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.core.api.AgentService;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.executor.standalone.ServiceThread;
import com.lubanops.apm.core.transaction.TransactionReportService;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.TxDataBody;
import com.lubanops.apm.integration.access.inbound.TxDataRequest;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;

public class TransactionReportServiceImpl
extends ServiceThread
implements TransactionReportService,
AgentService {
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final Logger LOGGER = LogFactory.getLogger();
    private int dataQueueSize = 128;
    public ArrayBlockingQueue<TxDataBody> txDataQueue = new ArrayBlockingQueue(this.dataQueueSize);
    private volatile boolean closed = false;
    private boolean hasException = Boolean.FALSE;
    private InvokerService invokerService = TransferInvokerService.getInstance();
    private static volatile TransactionReportServiceImpl instance;

    public TransactionReportServiceImpl() {
        super(TransactionReportServiceImpl.class.getSimpleName());
    }

    public static synchronized TransactionReportServiceImpl getInstance() {
        if (instance == null) {
            instance = new TransactionReportServiceImpl();
        }
        return instance;
    }

    @Override
    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int shutdownTimeout = 1000;
        if (shutdownTimeout > 0) {
            long start = System.currentTimeMillis();
            while (this.txDataQueue.isEmpty() && System.currentTimeMillis() - start < (long)shutdownTimeout) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
        }
        this.txDataQueue.clear();
        this.shutdown(true);
    }

    @Override
    public void init() throws ApmRuntimeException {
        this.start();
    }

    @Override
    public boolean offer(TxDataBody body) {
        boolean success = this.txDataQueue.offer(body);
        if (!success) {
            String bodyStr = body.toString();
            APMCollector.onDiscard((String)"TxData", (long)bodyStr.getBytes().length);
            LOGGER.warningFullQueue("data queue is full,data discarded:" + bodyStr);
        } else {
            APMCollector.onStart((String)"TxData", (int)this.txDataQueue.size());
        }
        return success;
    }

    @Override
    public void run() {
        LOGGER.info("[TX REPORTER]reporter start.");
        while (!this.isStopped()) {
            this.doReport();
        }
        LOGGER.info("[TX REPORTER]reporter stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReport() {
        TxDataRequest txRequest = new TxDataRequest();
        TxDataBody body = null;
        long startTime = 0L;
        long length = 0L;
        try {
            body = this.txDataQueue.take();
            txRequest.setHeader(ReportDataBuilder.buildTxDataHeader());
            txRequest.setMessageId(MessageIdGenerator.generateMessageId());
            txRequest.getHeader().setNeedResponse(false);
            txRequest.setBody(body);
            startTime = System.currentTimeMillis();
            String bodyStr = txRequest.getBodyString();
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message:[%s]", txRequest));
            length = bodyStr.getBytes().length;
            if (length > 1000000L) {
                LOGGER.log(Level.SEVERE, "data\u8fc7\u5927:" + bodyStr);
                APMCollector.onThrowable((String)"TxData", (long)length, (Throwable)new ApmRuntimeException("\u4e0a\u62a5\u6570\u636e\u8d85\u8fc71M"));
            }
            this.sendData(txRequest, bodyStr, length);
        }
        catch (Exception e) {
            if (!this.hasException) {
                LOGGER.log(Level.SEVERE, this.getServiceName() + " has exception.", (Throwable)e);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this.getServiceName() + " has exception.", (Throwable)e);
            }
            APMCollector.onThrowable((String)"TxData", (long)length, (Throwable)e);
            this.hasException = true;
        }
        finally {
            if (body != null) {
                APMCollector.onFinally((String)"TxData", (long)(System.currentTimeMillis() - startTime));
            }
        }
        return true;
    }

    private void sendData(TxDataRequest request, String bodyStr, long length) throws ConnectionException, IOException {
        if (this.invokerService.isSendEnable()) {
            this.invokerService.sendDataReport((MessageWrapper)request);
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message success:[%s]", request.getMessageId()));
        } else {
            APMCollector.onDiscard((String)"TxData", (long)bodyStr.getBytes().length);
        }
        APMCollector.onSuccess((String)"TxData", (long)length);
    }

    @Override
    public String getServiceName() {
        return TransactionReportServiceImpl.class.getSimpleName();
    }

    @Override
    protected void onWaitEnd() {
    }
}

