/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

class MySSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    public static final String SOCKS_ADDRESS = "socks.address";
    private static SSLContext sslContext = null;
    private static HostnameVerifier hostnameVerifier = null;
    public static final MySSLConnectionSocketFactory INSTANCE;

    public static SSLConnectionSocketFactory getSocketFactory() {
        return INSTANCE;
    }

    public MySSLConnectionSocketFactory() {
        super(sslContext, hostnameVerifier);
    }

    public Socket createSocket(HttpContext context) throws IOException {
        InetSocketAddress socksAddr = (InetSocketAddress)context.getAttribute(SOCKS_ADDRESS);
        if (socksAddr != null) {
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksAddr);
            return new Socket(proxy);
        }
        return super.createSocket(context);
    }

    static {
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).setProtocol("TLSv1.2").build();
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("failed to get SSLContext", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("failed to get SSLContext", e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("failed to get SSLContext", e);
        }
        hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
        INSTANCE = new MySSLConnectionSocketFactory();
    }
}

