/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb.impl;

import com.lubanops.huawei.bsp.encrypt.cbb.CipherException;
import com.lubanops.huawei.bsp.encrypt.cbb.CipherManager;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyException;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.KeyManagerUtil;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.PBKDF2WithHmacSHA256;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.Root;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public class KeyManagerImpl {
    private static final Map<MapKey, Key> K = new HashMap<MapKey, Key>();

    private KeyManagerImpl() {
    }

    private static void writeKeyFile(File newkey, byte[] keys, int keyscount, byte[] key) throws KeyException {
        if (keyscount < 16) {
            byte[] result = new byte[key.length + keys.length];
            System.arraycopy(key, 0, result, 0, key.length);
            System.arraycopy(keys, 0, result, key.length, keys.length);
            KeyManagerUtil.writeKeyFile(result, newkey);
        } else {
            byte[] result = new byte[16384];
            System.arraycopy(key, 0, result, 0, key.length);
            System.arraycopy(keys, 0, result, key.length, keys.length - key.length * 2);
            System.arraycopy(keys, result.length - key.length, result, result.length - key.length, key.length);
            KeyManagerUtil.writeKeyFile(result, newkey);
        }
    }

    public static Key readRootKey(File rootKey, int version) throws KeyException {
        try {
            MapKey mapkey = new MapKey(rootKey.getCanonicalPath(), version);
            Key mapkeyvalue = K.get(mapkey);
            if (mapkeyvalue != null) {
                return mapkeyvalue;
            }
            byte[] key = KeyManagerImpl.readKey(rootKey, version);
            int sequenceInt = KeyManagerUtil.getKeyVersionInt(key);
            mapkey = new MapKey(rootKey.getCanonicalPath(), sequenceInt);
            mapkeyvalue = K.get(mapkey);
            if (mapkeyvalue != null) {
                return mapkeyvalue;
            }
            mapkeyvalue = KeyManagerImpl.generateKey(key, true, rootKey);
            K.put(mapkey, mapkeyvalue);
            return mapkeyvalue;
        }
        catch (IOException e) {
            throw new KeyException("invalid version param.");
        }
    }

    public static Key readWorkKey(File rootKey, File workKey, int version) throws KeyException {
        try {
            MapKey mapkey = new MapKey(workKey.getCanonicalPath(), version);
            Key mapkeyvalue = K.get(mapkey);
            if (mapkeyvalue != null) {
                return mapkeyvalue;
            }
            byte[] key = KeyManagerImpl.readKey(workKey, version);
            int sequenceInt = KeyManagerUtil.getKeyVersionInt(key);
            mapkey = new MapKey(workKey.getCanonicalPath(), sequenceInt);
            mapkeyvalue = K.get(mapkey);
            if (mapkeyvalue != null) {
                return mapkeyvalue;
            }
            mapkeyvalue = KeyManagerImpl.generateKey(key, false, rootKey);
            K.put(mapkey, mapkeyvalue);
            return mapkeyvalue;
        }
        catch (IOException e) {
            throw new KeyException("invalid version param.");
        }
    }

    public static int getLatestVersion(File keyfile) throws KeyException {
        byte[] key = KeyManagerImpl.readKey(keyfile, 0);
        return KeyManagerUtil.getKeyVersionInt(key);
    }

    private static byte[] readKey(File keyfile, int version) throws KeyException {
        byte[] keys = KeyManagerUtil.readKeyFile(keyfile);
        int keysCount = KeyManagerUtil.checkKeys(keys);
        int max = -1;
        int index = -1;
        byte[] key = new byte[1024];
        for (int i = 0; i < keysCount; ++i) {
            System.arraycopy(keys, i * 1024, key, 0, 1024);
            int v = KeyManagerUtil.getKeyVersionInt(key);
            if (version == 0) {
                if (v <= max) continue;
                max = v;
                index = i;
                continue;
            }
            if (v != version) continue;
            return key;
        }
        if (max != -1) {
            System.arraycopy(keys, index * 1024, key, 0, 1024);
            return key;
        }
        throw new KeyException("invalid version param.");
    }

    private static void checkExistFile(File file) throws KeyException {
        if (!file.exists()) {
            throw new KeyException("file not exists :" + file.getName());
        }
    }

    private static void checkNotExistFile(File newkey) throws KeyException {
        if (newkey.exists()) {
            throw new KeyException("file already exists :" + newkey.getName());
        }
        File newkeyParent = newkey.getParentFile();
        if (newkeyParent != null && !newkeyParent.exists() && !newkeyParent.mkdirs()) {
            throw new KeyException("Can not create directory for file." + newkey.getName());
        }
    }

    private static Key generateKey(byte[] key, boolean isRoot, File rootkey) throws KeyException {
        try {
            byte[] algNameBytes = new byte[4];
            System.arraycopy(key, 8, algNameBytes, 0, 4);
            byte[] algIterationBytes = new byte[4];
            System.arraycopy(key, 12, algIterationBytes, 0, 4);
            byte[] algKeylenBytes = new byte[4];
            System.arraycopy(key, 16, algKeylenBytes, 0, 4);
            byte[] algSalt = new byte[32];
            System.arraycopy(key, 20, algSalt, 0, 32);
            byte[] keymaterialLen = new byte[4];
            System.arraycopy(key, 52, keymaterialLen, 0, 4);
            int keymaterialLenInt = KeyManagerUtil.bytesToInt(keymaterialLen);
            byte[] keymaterial = new byte[keymaterialLenInt];
            System.arraycopy(key, 128, keymaterial, 0, keymaterial.length);
            if (isRoot) {
                keymaterial = Root.root(keymaterial);
            } else {
                CipherManager cm = CipherManager.getInstance();
                keymaterial = cm.decrypt(keymaterial, rootkey);
            }
            int algIterationInt = KeyManagerUtil.bytesToInt(algIterationBytes);
            int algKeylenInt = KeyManagerUtil.bytesToInt(algKeylenBytes);
            int algNameInt = KeyManagerUtil.bytesToInt(algNameBytes);
            if (algNameInt == 2) {
                return PBKDF2WithHmacSHA256.generateKey(keymaterial, algSalt, algIterationInt, algKeylenInt);
            }
            throw new KeyException("Not supported key gen algorithm : " + algNameInt);
        }
        catch (CipherException e) {
            throw new KeyException(e.getMessage());
        }
    }

    static class MapKey {
        private final String name;
        private final int sequence;
        private int hash = -1;

        public MapKey(String n, int s) {
            this.name = n;
            this.sequence = s;
        }

        public boolean equals(Object other) {
            if (other instanceof MapKey) {
                MapKey o = (MapKey)other;
                return this.name.equals(o.name) && this.sequence == o.sequence;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == -1) {
                this.hash = this.name.hashCode() + this.sequence;
            }
            return this.hash;
        }
    }
}

