/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.moquette.broker.processors;

import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.plugin.moquette.broker.processors.MqttMessageProcessor;
import io.moquette.broker.NettyUtils;
import io.moquette.broker.Utils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;

public class MqttSubscribeMessageProcessor
implements MqttMessageProcessor {
    @Override
    public boolean process(ChannelHandlerContext ctx, MqttMessage msg, SpanEvent spanEvent) {
        if (!(msg instanceof MqttSubscribeMessage)) {
            return false;
        }
        MqttSubscribeMessage mqttSubscribeMessage = (MqttSubscribeMessage)msg;
        String operationName = "Mqtt/SUBSCRIBE";
        spanEvent.setMethod(spanEvent.getMethod() + "(" + operationName + ")");
        spanEvent.addTag("mqtt.clientId", NettyUtils.clientID((Channel)ctx.channel()));
        if (msg.variableHeader() instanceof MqttMessageIdVariableHeader) {
            spanEvent.addTag("mqtt.messageId", String.valueOf(Utils.messageId((MqttMessage)msg)));
        }
        spanEvent.addTag("mqtt.topicSubscriptions", mqttSubscribeMessage.payload().topicSubscriptions().toString());
        return true;
    }
}

