/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.client.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.plugin.grpc.server.stats.ClientStatsBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientAggregator
extends SinglePrimaryKeyAggregator<ClientStatsBase> {
    public String getName() {
        return "detail";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected != null && !collected.isEmpty()) {
            HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
            ArrayList<MonitorDataRow> clusterRows = new ArrayList<MonitorDataRow>();
            HashMap<String, MonitorDataRow> map = new HashMap<String, MonitorDataRow>();
            for (MonitorDataRow detailRow : collected) {
                MonitorDataRow row;
                String envId = (String)detailRow.get((Object)"envId");
                if (envId == null) {
                    envId = "unknow";
                }
                if ((row = (MonitorDataRow)map.get(envId)) == null) {
                    row = new MonitorDataRow();
                    row.put((Object)"clusterId", (Object)envId);
                    map.put(envId, row);
                    clusterRows.add(row);
                }
                this.setNewCount(row, detailRow, "invokeCount");
                this.setNewCount(row, detailRow, "totalTime");
                this.setNewCount(row, detailRow, "errorCount");
            }
            result.put("cluster", clusterRows);
            return result;
        }
        return null;
    }

    protected String primaryKey() {
        return "method";
    }

    protected Class<ClientStatsBase> getValueType() {
        return ClientStatsBase.class;
    }

    public Map<String, Object> onStart(String method) {
        HashMap<String, Object> collectorContext = new HashMap<String, Object>();
        ClientStatsBase clientStatsBase = (ClientStatsBase)this.getValue(method);
        if (clientStatsBase != null) {
            long startTime = clientStatsBase.onStart();
            collectorContext.put("startTime", startTime);
            collectorContext.put("statsBase", (Object)clientStatsBase);
            return collectorContext;
        }
        return null;
    }

    public void onError(ClientStatsBase clientStatsBase) {
        clientStatsBase.onError();
    }

    public void onFinally(ClientStatsBase clientStatsBase, Long startTime, String envId) {
        long endTime = System.nanoTime();
        long useTime = endTime - startTime;
        clientStatsBase.setEnvId(envId);
        clientStatsBase.onFinally(useTime);
    }

    private void setNewCount(MonitorDataRow row, MonitorDataRow detailRow, String key) {
        Long oldCountL = (Long)row.get((Object)key);
        Long addCountL = (Long)detailRow.get((Object)key);
        if (oldCountL == null) {
            oldCountL = 0L;
        }
        if (addCountL == null) {
            addCountL = 0L;
        }
        row.put((Object)key, (Object)(oldCountL + addCountL));
    }
}

