/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.client.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.grpc.client.collector.ClientCollector;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentelemetry.api.trace.Span;
import java.util.HashMap;
import java.util.Map;

public class ClientCallImplInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (ClientCollector.INSTANCE.isEnable() && "start".equals(methodName)) {
            Object[] fileds;
            this.saveSpanEvent(object);
            Metadata headers = (Metadata)args[1];
            headers.put(Metadata.Key.of((String)Headers.ENV_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(IdentityConfigManager.getEnvId()));
            headers.put(Metadata.Key.of((String)Headers.DOMAIN_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(IdentityConfigManager.getDomainId()));
            headers.put(Metadata.Key.of((String)Headers.DOMAIN_TYPE.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(IdentityConfigManager.getDomainType()));
            if (object instanceof AttributeAccess && object instanceof TransformAccess && (fileds = ((AttributeAccess)object).getLopsFileds()).length > 0 && fileds[0] instanceof MethodDescriptor) {
                String fullMethodName = ((MethodDescriptor)fileds[0]).getFullMethodName();
                Map<String, Object> collectorMap = ClientCollector.onStart(fullMethodName);
                this.saveCollectorMap(object, collectorMap);
                SpanEvent spanEvent = null;
                String gtraceId = null;
                String userFlag = null;
                Object eventObject = ((TransformAccess)object).getLopsAttribute();
                if (eventObject != null && eventObject instanceof Map) {
                    spanEvent = (SpanEvent)((Map)eventObject).get("spanEvent");
                    gtraceId = (String)((Map)eventObject).get("gtraceId");
                    userFlag = (String)((Map)eventObject).get("userFlag");
                }
                if (spanEvent != null) {
                    String w3CHeader;
                    spanEvent.addTag("fullMethodName", fullMethodName);
                    String nextSpanId = spanEvent.generateNextSpanId();
                    String traceId = spanEvent.getTraceId();
                    headers.put(Metadata.Key.of((String)Headers.TRACE_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)traceId);
                    headers.put(Metadata.Key.of((String)Headers.SPAN_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)nextSpanId);
                    headers.put(Metadata.Key.of((String)Headers.SOURCE_EVENT_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)spanEvent.getEventId());
                    if (spanEvent.hasSamplingPolicy()) {
                        headers.put(Metadata.Key.of((String)Headers.POLICY_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)spanEvent.getPolicyId());
                    }
                    if ((w3CHeader = TraceCollector.getW3CHeader((Span)spanEvent.getOtelSpan())) != null) {
                        headers.put(Metadata.Key.of((String)Headers.OTEL_HEADER.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)w3CHeader);
                    }
                }
                if (!StringUtils.isBlank(gtraceId)) {
                    headers.put(Metadata.Key.of((String)Headers.GTRACE_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), gtraceId);
                }
                if (!StringUtils.isBlank(userFlag)) {
                    headers.put(Metadata.Key.of((String)Headers.USER_FLAG.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), userFlag);
                }
            }
        }
        return null;
    }

    private void saveCollectorMap(Object object, Map<String, Object> collectorMap) {
        if (object instanceof TransformAccess) {
            Object attribute = ((TransformAccess)object).getLopsAttribute();
            HashMap<String, Map<String, Object>> map = null;
            if (attribute != null && attribute instanceof Map) {
                map = (HashMap<String, Map<String, Object>>)attribute;
            }
            if (map == null) {
                map = new HashMap<String, Map<String, Object>>();
                ((TransformAccess)object).setLopsAttribute(map);
            }
            map.put("clientCollectorContext", collectorMap);
        }
    }

    private void saveSpanEvent(Object object) {
        Object attribute;
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent != null && object instanceof TransformAccess && "io/grpc/stub/ClientCalls".equals(spanEvent.getClassName()) && (attribute = ((TransformAccess)object).getLopsAttribute()) == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("spanEvent", spanEvent);
            map.put("gtraceId", TraceCollector.G_TRACE_ID_THREAD_LOCAL.get());
            map.put("userFlag", TraceCollector.USER_FLAG_THREAD_LOCAL.get());
            map.put("policyId", TraceCollector.POLICY_ID_THREAD_LOCAL.get());
            ((TransformAccess)object).setLopsAttribute(map);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (ClientCollector.INSTANCE.isEnable() && "closeObserver".equals(methodName)) {
            Status status = (Status)args[1];
            Metadata metadata = (Metadata)args[2];
            String envId = (String)metadata.get(Metadata.Key.of((String)Headers.ENV_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            if (object instanceof TransformAccess) {
                SpanEvent spanEvent = null;
                Object eventObject = ((TransformAccess)object).getLopsAttribute();
                Map map = null;
                if (eventObject != null && eventObject instanceof Map) {
                    spanEvent = (SpanEvent)((Map)eventObject).get("spanEvent");
                    map = (Map)((Map)eventObject).get("clientCollectorContext");
                }
                if (map != null) {
                    if (!status.isOk()) {
                        ClientCollector.onError(map);
                    }
                    ClientCollector.onFinally(envId, map);
                }
                if (spanEvent != null) {
                    spanEvent.addTag("code", String.valueOf(status.getCode().name()));
                    TraceCollector.onError((SpanEvent)spanEvent, (Throwable)status.getCause());
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
    }
}

