/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.PoolObjectHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ConnectionPoolRouteAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            result.addAll(this.buildRows(o));
        }
        return result;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    private List<MonitorDataRow> buildRows(Object obj) {
        Object poolId;
        ArrayList<MonitorDataRow> list = new ArrayList<MonitorDataRow>();
        if (obj instanceof PoolingHttpClientConnectionManager && obj instanceof TransformAccess && (poolId = ((TransformAccess)obj).getLopsAttribute()) != null) {
            PoolingHttpClientConnectionManager pm = (PoolingHttpClientConnectionManager)obj;
            Set httpRoutes = pm.getRoutes();
            for (HttpRoute httpRoute : httpRoutes) {
                MonitorDataRow row = new MonitorDataRow();
                row.put((Object)"poolId", (Object)String.valueOf(poolId));
                row.put((Object)"route", (Object)httpRoute.toString());
                row.put((Object)"leased", (Object)pm.getStats(httpRoute).getLeased());
                row.put((Object)"pending", (Object)pm.getStats(httpRoute).getPending());
                row.put((Object)"available", (Object)pm.getStats(httpRoute).getAvailable());
                row.put((Object)"max", (Object)pm.getStats(httpRoute).getMax());
                list.add(row);
            }
        }
        return list;
    }

    public String getName() {
        return "connectionPoolRoute";
    }

    public void clear() {
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String poolId = primaryKeyMap.get("poolId");
        String route = primaryKeyMap.get("route");
        if (poolId == null || route == null) {
            return null;
        }
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            List<MonitorDataRow> rows = this.buildRows(o);
            for (MonitorDataRow row : rows) {
                if (!poolId.equals(row.get((Object)"poolId")) || !route.equals(row.get((Object)"route"))) continue;
                return row;
            }
        }
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList poolList = PoolObjectHolder.getPoolList();
        for (Object o : poolList) {
            result.addAll(this.buildRows(o));
        }
        return result;
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

