/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.obsclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.plugin.obsclient.collector.ObsClientCollector;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class RestStorageInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (ObsClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request) {
                Request request = (Request)args[0];
                String bucketName = (String)args[2];
                HttpUrl httpUrl = request.url();
                List pathSegments = httpUrl.pathSegments();
                String hostUri = httpUrl.scheme() + "://" + httpUrl.host() + ":" + httpUrl.port();
                ObsClientCollector.onStart(hostUri, httpUrl.toString(), request.method(), bucketName, pathSegments);
                ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.set(Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (ObsClientCollector.INSTANCE.isEnable()) {
                ObsClientCollector.onThrowable(e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (ObsClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request && result instanceof Response) {
                Request request = (Request)args[0];
                String requestUri = request.url().toString();
                Response response = (Response)result;
                int code = response.code();
                ObsClientCollector.onStatusCode(requestUri, code);
                ObsClientCollector.onFinally(code);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

