/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith;

import com.huawei.gauss.channel.context.statement.RowsData;
import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss200.jdbc.jdbc.PgStatement;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.Connection;
import java.sql.SQLException;

public class GaussUtils {
    public static int getReadRows(GaussResultSetImpl resultSet) {
        int res = 0;
        if (resultSet instanceof AttributeAccess) {
            RowsData rowsData = (RowsData)((AttributeAccess)resultSet).getLopsFileds()[0];
            res = rowsData.getRowCount();
        }
        return res;
    }

    public static String getHostPostPair(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            return socketAddress.getHostName() + ":" + socketAddress.getPort();
        }
        return address.toString();
    }

    public static String getHostPostPair(com.huawei.gauss200.jdbc.util.HostSpec hostSpec) {
        return hostSpec.getHost() + ":" + hostSpec.getPort();
    }

    public static String getHostPostPair(HostSpec hostSpec) {
        return hostSpec.getHost() + ":" + hostSpec.getPort();
    }

    public static Integer getConnectionId(GaussStatement statement) throws SQLException {
        Connection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)((TransformAccess)connection).getLopsAttribute();
        }
        return null;
    }

    public static Integer getConnectionId(PgStatement statement) throws SQLException {
        Connection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)((TransformAccess)connection).getLopsAttribute();
        }
        return null;
    }

    public static Integer getConnectionId(com.huawei.gaussdb.jdbc.jdbc.PgStatement statement) throws SQLException {
        Connection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)((TransformAccess)connection).getLopsAttribute();
        }
        return null;
    }

    public static void onStatementStart(String sql, Integer connectionId) {
        try {
            ConnectionStats connectionStats;
            if (connectionId != null && (connectionStats = GaussDbCollector.onConnectionStart(connectionId)) != null) {
                GaussDbCollector.onStart(sql, connectionId);
            }
        }
        catch (Exception statementOnStartException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)statementOnStartException);
        }
    }

    public static void onStatementError(Throwable e, String sql) {
        try {
            GaussDbCollector.onConnectionException(e, sql);
            GaussDbCollector.onThrowable(e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

