/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.cassandra3.CassandraStatsConfig;
import com.lubanops.apm.plugin.cassandra3.stats.CassandraCqlStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CassandraCqlAggregator
extends SinglePrimaryKeyAggregator<CassandraCqlStats> {
    private static final String CQL = "cql";
    private static final String CASSANDRA_PARSE_ORIGINAL_CQL = "CassandraParseOriginalCql";

    public void parseParameters(Map<String, String> parameters) {
        Boolean isParseOriginalCql = ParameterParseUtil.getBoolean(parameters, (String)CASSANDRA_PARSE_ORIGINAL_CQL);
        if (isParseOriginalCql != null) {
            CassandraStatsConfig.setParseOriginalCql(isParseOriginalCql);
        }
    }

    public void incrementQueryCountAsync(Map<String, Object> context, long count) {
        if (!this.isEnable) {
            return;
        }
        CassandraCqlStats stats = (CassandraCqlStats)((Object)context.get("stats"));
        if (stats != null) {
            stats.incrementQueryRowCount(count);
        }
    }

    public Map<String, Object> onStartAsync(String cql) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        CassandraCqlStats stats = (CassandraCqlStats)this.getValue(cql);
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
        }
        return map;
    }

    public Map<String, Object> onErrorAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return context;
        }
        CassandraCqlStats stats = (CassandraCqlStats)((Object)context.get("stats"));
        if (stats != null) {
            stats.onError(traceId);
        }
        return context;
    }

    public void onFinallyAsync(Map<String, Object> context, String traceId) {
        if (!this.isEnable) {
            return;
        }
        Long startTime = (Long)context.get("startTime");
        CassandraCqlStats stats = (CassandraCqlStats)((Object)context.get("stats"));
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalQueryCount = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long queryCount = (Long)row.get((Object)"queryRowCount");
                Long errorCount = (Long)row.get((Object)"errorCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (queryCount == null) {
                    queryCount = 0L;
                }
                if (errorCount == null) {
                    errorCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalQueryCount += queryCount.longValue();
                totalErrorCount += errorCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"queryRowCount", (Object)totalQueryCount);
        totalRow.put((Object)"errorCount", (Object)totalErrorCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<CassandraCqlStats> getValueType() {
        return CassandraCqlStats.class;
    }

    protected String primaryKey() {
        return CQL;
    }

    public String getName() {
        return CQL;
    }
}

