/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.interceptor;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.cassandra3.CassandraContext;
import com.lubanops.apm.plugin.cassandra3.CassandraStatsConfig;
import com.lubanops.apm.plugin.cassandra3.CassandraUtils;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraCollector;
import java.util.Map;
import java.util.concurrent.Executor;

public class ExecuteAsyncInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"Cassandra");
                Statement statement = (Statement)args[0];
                String originalCql = CassandraUtils.getOriginalCqlQueryTruncated(statement);
                String parsedCql = CassandraUtils.getParsedCqlQuery(originalCql);
                Map<String, Object> context = CassandraCollector.onStartAsync(parsedCql);
                if (spanEvent != null) {
                    String keyspace = statement.getKeyspace();
                    if (keyspace != null) {
                        spanEvent.addTag("keyspace", keyspace);
                    }
                    spanEvent.addTag("cql", parsedCql);
                    if (CassandraStatsConfig.isParseOriginalCql()) {
                        spanEvent.addTag("originalCql", originalCql);
                    }
                }
                CassandraContext.CONTEXT_LOCAL.set(context);
            }
        }
        catch (Exception executeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executeException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                ResultSetFuture resultSetFuture = (ResultSetFuture)result;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                Map<String, Object> context = CassandraContext.CONTEXT_LOCAL.get();
                CassandraContext.CONTEXT_LOCAL.remove();
                this.addExecutionCallback(resultSetFuture, spanEvent, context);
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Exception executeException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)executeException);
        }
    }

    private void addExecutionCallback(ResultSetFuture future, final SpanEvent spanEvent, final Map<String, Object> context) {
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                ExecuteAsyncInterceptor.this.executeOnSuccess(result, spanEvent, context);
            }

            public void onFailure(Throwable t) {
                ExecuteAsyncInterceptor.this.executeOnFailure(t, spanEvent, context);
            }
        }, (Executor)new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    private void executeOnSuccess(ResultSet resultSet, SpanEvent spanEvent, Map<String, Object> context) {
        int queryRowCount = CassandraUtils.getFetchedCount(resultSet);
        CassandraCollector.incrementQueryCountAsync(context, queryRowCount);
        String traceId = spanEvent == null ? null : spanEvent.getTraceId();
        CassandraCollector.onFinallyAsync(context, traceId);
        if (spanEvent != null) {
            spanEvent.addTag("queryRowCount", String.valueOf(queryRowCount));
            TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
        }
    }

    private void executeOnFailure(Throwable t, SpanEvent spanEvent, Map<String, Object> context) {
        String traceId = spanEvent == null ? null : spanEvent.getTraceId();
        CassandraCollector.onException(t);
        context = CassandraCollector.onErrorAsync(context, traceId);
        CassandraCollector.onFinallyAsync(context, traceId);
        if (spanEvent != null) {
            TraceCollector.onError((SpanEvent)spanEvent, (Throwable)t);
            TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
        }
    }
}

